/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaFieldCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class GroovyFieldProposal
extends AbstractGroovyProposal {
    private final FieldNode field;

    public GroovyFieldProposal(FieldNode field) {
        this.field = field;
    }

    @Override
    public AnnotatedNode getAssociatedNode() {
        return this.field;
    }

    public FieldNode getField() {
        return this.field;
    }

    @Override
    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
            return null;
        }
        GroovyCompletionProposal proposal = new GroovyCompletionProposal(2, context.completionLocation);
        proposal.setName(this.field.getName().toCharArray());
        char[] completion = proposal.getName();
        if (context.location == ContentAssistLocation.STATEMENT && this.field.getDeclaringClass().equals((Object)VariableScope.CLASS_CLASS_NODE)) {
            completion = CharOperation.concat((char[])"this.".toCharArray(), (char[])completion);
        } else if (this.getRequiredQualifier() != null) {
            completion = CharOperation.concat((char[])this.getRequiredQualifier().toCharArray(), (char[])completion, (char)'.');
        }
        proposal.setCompletion(completion);
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(this.field.getDeclaringClass()));
        proposal.setFlags(this.field.getModifiers() | (GroovyUtils.isDeprecated((ASTNode)this.field) ? 0x100000 : 0));
        proposal.setRelevance(this.computeRelevance(context));
        proposal.setReplaceRange(context.completionLocation - context.completionExpression.length(), context.completionEnd);
        proposal.setSignature(ProposalUtils.createTypeSignature(this.field.getType()));
        if (this.getRequiredStaticImport() != null) {
            CompletionProposal importProposal;
            if (new AssistOptions((Map)javaContext.getProject().getOptions((boolean)true)).suggestStaticImport) {
                importProposal = CompletionProposal.create((int)21, (int)context.completionLocation);
                importProposal.setAdditionalFlags(1);
                importProposal.setDeclarationSignature(proposal.getDeclarationSignature());
                importProposal.setName(proposal.getName());
            } else {
                ReflectionUtils.setPrivateField(InternalCompletionProposal.class, (String)"completionKind", (Object)((Object)proposal), (Object)6);
                importProposal = CompletionProposal.create((int)23, (int)context.completionLocation);
                importProposal.setSignature(proposal.getDeclarationSignature());
            }
            proposal.setRequiredProposals(new CompletionProposal[]{importProposal});
        }
        GroovyJavaFieldCompletionProposal javaProposal = new GroovyJavaFieldCompletionProposal((CompletionProposal)proposal, this.createDisplayString(this.field), javaContext);
        MethodNode groovyMethod = (MethodNode)this.field.getNodeMetaData((Object)"groovy.method");
        if (groovyMethod != null) {
            try {
                IMethod method;
                IType type = javaContext.getProject().findType(groovyMethod.getDeclaringClass().getName());
                if (type != null && (method = type.getMethod(groovyMethod.getName(), GroovyUtils.getParameterTypeSignatures((MethodNode)groovyMethod, (boolean)true))) != null && method.exists()) {
                    ProposalInfo proposalInfo = (ProposalInfo)ReflectionUtils.executePrivateMethod(AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Object)((Object)javaProposal));
                    ReflectionUtils.throwableSetPrivateField(MemberProposalInfo.class, (String)"fJavaElementResolved", (Object)proposalInfo, (Object)Boolean.TRUE);
                    ReflectionUtils.throwableSetPrivateField(ProposalInfo.class, (String)"fElement", (Object)proposalInfo, (Object)method);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return javaProposal;
    }

    protected StyledString createDisplayString(FieldNode field) {
        return new StyledString().append(field.getName()).append(" : ").append(ProposalUtils.createSimpleTypeName(field.getType())).append(" - ").append(ProposalUtils.createSimpleTypeName(field.getDeclaringClass()), StyledString.QUALIFIER_STYLER);
    }
}

