/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.NamedParameterProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class GroovyNamedArgumentProposal
implements IGroovyProposal {
    private final String paramName;
    private final String paramSignature;
    private final MethodNode ownerMethod;
    private final String contributor;

    public GroovyNamedArgumentProposal(String paramName, String paramSignature, MethodNode ownerMethod, String contributor) {
        this.paramName = paramName;
        this.paramSignature = paramSignature;
        this.ownerMethod = ownerMethod;
        this.contributor = contributor;
    }

    public GroovyNamedArgumentProposal(String paramName, ClassNode paramType, MethodNode ownerMethod, String contributor) {
        this(paramName, String.valueOf(ProposalUtils.createTypeSignature(paramType)), ownerMethod, contributor);
    }

    @Override
    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (context.location != ContentAssistLocation.METHOD_CONTEXT) {
            return null;
        }
        MethodInfoContentAssistContext methodContext = (MethodInfoContentAssistContext)context;
        int offset = methodContext.completionLocation - methodContext.completionExpression.length();
        int length = methodContext.completionEnd - offset;
        Image image = ProposalUtils.getParameterImage();
        StyledString displayString = this.createDisplayString();
        int relevance = Relevance.VERY_HIGH.getRelevance();
        boolean inJavadoc = false;
        return new NamedParameterProposal(this.paramName, this.paramSignature, offset, length, image, displayString, relevance, inJavadoc, javaContext);
    }

    protected StyledString createDisplayString() {
        return new StyledString().append(this.paramName).append(" : __ - ").append(Signature.toString((String)this.paramSignature)).append(" : named parameter of ", StyledString.QUALIFIER_STYLER).append(this.contributor, StyledString.DECORATIONS_STYLER);
    }
}

