/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.search.CategoryTypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupRegistry;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeInferencingVisitorFactory {
    public TypeInferencingVisitorWithRequestor createVisitor(PossibleMatch possibleMatch) {
        if (possibleMatch.openable instanceof GroovyCompilationUnit) {
            return this.createVisitor((GroovyCompilationUnit)possibleMatch.openable);
        }
        if (possibleMatch.openable instanceof ClassFile) {
            return this.createVisitor(new GroovyClassFileWorkingCopy((ClassFile)possibleMatch.openable, null));
        }
        throw new IllegalStateException("Attempted to do a groovy visit on a non-groovy file: " + String.valueOf(possibleMatch.getFileName()));
    }

    public TypeInferencingVisitorWithRequestor createVisitor(GroovyCompilationUnit compilationUnit) {
        ArrayList<ITypeLookup> lookups = new ArrayList<ITypeLookup>();
        IProject project = compilationUnit.getJavaProject().getProject();
        try {
            lookups.addAll(TypeLookupRegistry.getRegistry().getLookupsFor(project));
        }
        catch (CoreException e) {
            Util.log((Throwable)e, (String)("Failed to retrieve ITypeLookup instances for project " + project.getName()));
        }
        lookups.add(new CategoryTypeLookup());
        lookups.add(new SimpleTypeLookup());
        return new TypeInferencingVisitorWithRequestor(compilationUnit, lookups.toArray(new ITypeLookup[lookups.size()]));
    }
}

