/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import com.kms.katalon.logging.SystemStreams;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class CustomConsoleAppender
extends AppenderBase<ILoggingEvent> {
    private ConsoleAppender<ILoggingEvent> delegate;
    private final CopyOnWriteArrayList<Consumer<ILoggingEvent>> consumers = new CopyOnWriteArrayList();
    private boolean broadcastOnly = false;
    private boolean muteStackTrace = false;
    private boolean muteNonKsStderr = false;

    public CustomConsoleAppender(ConsoleAppender<ILoggingEvent> delegate) {
        this.delegate = delegate;
        this.setContext(delegate.getContext());
        this.setName(delegate.getName() + "_custom");
        this.setEncoder((Encoder<ILoggingEvent>)delegate.getEncoder());
        delegate.getCopyOfAttachedFiltersList().forEach(arg_0 -> ((CustomConsoleAppender)this).addFilter(arg_0));
    }

    public void setBroadcastOnly(boolean broadcastOnly) {
        this.broadcastOnly = broadcastOnly;
    }

    public boolean isBroadcastOnly() {
        return this.broadcastOnly;
    }

    public boolean isMuteStackTrace() {
        return this.muteStackTrace;
    }

    public void setMuteStackTrace(boolean muteStackTrace) {
        this.muteStackTrace = muteStackTrace;
    }

    public boolean isMuteNonKsStderr() {
        return this.muteNonKsStderr;
    }

    public void setMuteNonKsStderr(boolean muteNonKsStderr) {
        this.muteNonKsStderr = muteNonKsStderr;
        if (muteNonKsStderr) {
            SystemStreams.getInstance().setSystemErrToNull();
        } else {
            SystemStreams.getInstance().setSystemErrToOriginal();
        }
    }

    public void addLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        if (consumer != null) {
            this.consumers.addIfAbsent(consumer);
        }
    }

    public void removeLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        this.consumers.remove(consumer);
    }

    protected void append(ILoggingEvent event) {
        if (this.delegate == null || !this.delegate.isStarted()) {
            return;
        }
        if (this.broadcastOnly && this.consumers.isEmpty()) {
            return;
        }
        ILoggingEvent finalEvent = event;
        if (this.muteStackTrace && event.getThrowableProxy() != null) {
            finalEvent = (ILoggingEvent)Proxy.newProxyInstance(ILoggingEvent.class.getClassLoader(), new Class[]{ILoggingEvent.class}, (InvocationHandler)new NoExceptionStackTraceProxyHandler(event));
        }
        if (!this.broadcastOnly) {
            if (ConsoleTarget.SystemErr.getName().equals(this.delegate.getTarget())) {
                try {
                    SystemStreams.getInstance().setSystemErrToOriginal();
                    this.delegate.doAppend((Object)finalEvent);
                }
                finally {
                    if (this.muteNonKsStderr) {
                        SystemStreams.getInstance().setSystemErrToNull();
                    }
                }
            } else {
                this.delegate.doAppend((Object)finalEvent);
            }
        }
        for (Consumer<ILoggingEvent> consumer : this.consumers) {
            try {
                consumer.accept(finalEvent);
            }
            catch (Exception exception) {}
        }
    }

    protected void setEncoder(Encoder<ILoggingEvent> encoder) {
        if (this.delegate != null) {
            this.delegate.setEncoder(encoder);
        }
    }

    private static class NoExceptionStackTraceProxyHandler
    implements InvocationHandler {
        private final ILoggingEvent delegate;

        NoExceptionStackTraceProxyHandler(ILoggingEvent delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getThrowableProxy".equals(method.getName())) {
                return null;
            }
            return method.invoke((Object)this.delegate, args);
        }
    }
}

