/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.kms.katalon.core.logging.logback.CustomConsoleAppender;
import com.kms.katalon.core.logging.logback.EclipseE4LogAppender;
import com.kms.katalon.core.logging.logback.EclipsePlatformFileAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    public static void init(File defaultConfigFile, File customConfigFile) throws IOException {
        LogbackConfigurator.initDefaultConfiguration(defaultConfigFile);
        LogbackConfigurator.initCustomConfiguration(customConfigFile);
        LogbackConfigurator.replaceConsoleAppenderWithCustom();
    }

    private static void initDefaultConfiguration(File configFile) {
        block6: {
            if (configFile == null || !configFile.exists()) {
                return;
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                try {
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext((Context)context);
                    context.reset();
                    configurator.doConfigure(configFile);
                }
                catch (JoranException joranException) {
                    StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
                throw throwable;
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        LoggerFactory.getLogger(LogbackConfigurator.class).info("Logback default configuration initialized from: {}", (Object)configFile.getAbsolutePath());
    }

    private static void initCustomConfiguration(File configFile) {
        Properties config = new Properties();
        try {
            if (configFile != null && configFile.exists()) {
                config.load(new FileInputStream(configFile));
            }
        }
        catch (Exception exception) {}
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Object key : config.keySet()) {
            String loggerName;
            String propKey = (String)key;
            if (!propKey.startsWith("logging.level.") || StringUtils.isBlank((CharSequence)(loggerName = propKey.substring("logging.level.".length())))) continue;
            String levelValue = config.getProperty(propKey);
            Level logLevel = Level.toLevel((String)levelValue);
            Logger logger = loggerContext.getLogger(loggerName);
            logger.setLevel(logLevel);
        }
        LoggerFactory.getLogger(LogbackConfigurator.class).info("Logback custom configuration initialized" + (String)(configFile != null ? " from: " + configFile.getAbsolutePath() : ""));
    }

    public static void setupEclipseE4LogAppender(org.eclipse.e4.core.services.log.Logger eclipseLogger) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        EclipseE4LogAppender eclipseLogAppender = new EclipseE4LogAppender();
        eclipseLogAppender.setContext((Context)loggerContext);
        eclipseLogAppender.setEclipseLogger(eclipseLogger);
        eclipseLogAppender.start();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.addAppender((Appender)eclipseLogAppender);
        if (LogbackConfigurator.isEclipseConsoleLogEnabled()) {
            Iterator it = rootLogger.iteratorForAppenders();
            while (it.hasNext()) {
                Appender appender = (Appender)it.next();
                if (!(appender instanceof CustomConsoleAppender)) continue;
                CustomConsoleAppender customConsoleAppender = (CustomConsoleAppender)appender;
                customConsoleAppender.setBroadcastOnly(true);
            }
        }
        rootLogger.info("Finished setup EclipseLogAppender");
    }

    public static void setupEclipsePlatformFileAppender() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        EclipsePlatformFileAppender appender = new EclipsePlatformFileAppender();
        appender.setContext((Context)loggerContext);
        appender.start();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.addAppender((Appender)appender);
        LoggerFactory.getLogger(LogbackConfigurator.class).info("Finished setup EclipsePlatformFileAppender: " + appender.getFile());
    }

    public static void muteNonKsStderr() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof CustomConsoleAppender)) continue;
            CustomConsoleAppender customConsoleAppender = (CustomConsoleAppender)appender;
            customConsoleAppender.setMuteNonKsStderr(true);
        }
    }

    public static void muteStackTraceInConsole() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof CustomConsoleAppender)) continue;
            CustomConsoleAppender customConsoleAppender = (CustomConsoleAppender)appender;
            customConsoleAppender.setMuteStackTrace(true);
        }
    }

    public static void addConsoleLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof CustomConsoleAppender)) continue;
            CustomConsoleAppender customConsoleAppender = (CustomConsoleAppender)appender;
            customConsoleAppender.addLogEventConsumer(consumer);
        }
    }

    public static void removeConsoleLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof CustomConsoleAppender)) continue;
            CustomConsoleAppender customConsoleAppender = (CustomConsoleAppender)appender;
            customConsoleAppender.removeLogEventConsumer(consumer);
        }
    }

    public static void addLogFilter(Filter<ILoggingEvent> filter) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            filter.start();
            appender.addFilter(filter);
        }
    }

    private static boolean isEclipseConsoleLogEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("eclipse.consoleLog")) || ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(arg -> arg.equals("-consoleLog"));
    }

    private static void replaceConsoleAppenderWithCustom() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList<ConsoleAppender> consoleAppenders = new ArrayList<ConsoleAppender>();
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppenders.add((ConsoleAppender)appender);
        }
        for (ConsoleAppender originalAppender : consoleAppenders) {
            CustomConsoleAppender newAppender = new CustomConsoleAppender((ConsoleAppender<ILoggingEvent>)originalAppender);
            newAppender.start();
            rootLogger.addAppender((Appender)newAppender);
            rootLogger.detachAppender((Appender)originalAppender);
        }
    }
}

