/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.Java14;

public class SSLSocketWrapper
extends SSLSocket {
    protected Socket s;

    public SSLSocketWrapper(Socket s) {
        this.s = s;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener hcl) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).addHandshakeCompletedListener(hcl);
        }
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener hcl) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).removeHandshakeCompletedListener(hcl);
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSupportedCipherSuites();
        }
        return null;
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getEnableSessionCreation();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getEnabledCipherSuites();
        }
        return null;
    }

    @Override
    public String[] getSupportedProtocols() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSupportedProtocols();
        }
        return null;
    }

    @Override
    public String[] getEnabledProtocols() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getEnabledProtocols();
        }
        return null;
    }

    @Override
    public SSLSession getSession() {
        if (this.s instanceof SSLSocket) {
            return ((SSLSocket)this.s).getSession();
        }
        return null;
    }

    @Override
    public boolean getUseClientMode() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getUseClientMode();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getNeedClientAuth();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.s instanceof SSLSocket && ((SSLSocket)this.s).getWantClientAuth();
    }

    @Override
    public void setEnabledCipherSuites(String[] cs) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnabledCipherSuites(cs);
        }
    }

    @Override
    public void setEnabledProtocols(String[] ep) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnabledProtocols(ep);
        }
    }

    @Override
    public void startHandshake() throws IOException {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).startHandshake();
        }
    }

    @Override
    public void setUseClientMode(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setUseClientMode(b);
        }
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setNeedClientAuth(b);
        }
    }

    @Override
    public void setWantClientAuth(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setWantClientAuth(b);
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (this.s instanceof SSLSocket) {
            ((SSLSocket)this.s).setEnableSessionCreation(b);
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.s.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.s.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.s.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.s.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.s.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.s.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.s.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.s.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.s.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.s.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.s.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.s.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.s.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.s.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.s.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.s.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.s.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.s.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.s.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.s.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.s.setOOBInline(on);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.s.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.s.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int l) throws SocketException {
        this.s.setSoLinger(on, l);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.s.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.s.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.s.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.s.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.s.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.s.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.s.bind(bindpoint);
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.s.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.s.connect(endpoint, timeout);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.s.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.s.getOutputStream();
    }

    public void setHost(String host) throws IOException {
        if (this.s instanceof SSLSocket) {
            Java14.setHostForSNI((SSLSocket)this.s, host);
        }
    }
}

