/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.impl.util.EntityIndexingUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;

public class IndexProjectHandler
extends AbstractHandler {
    private static final String INDEXING_PROJECT = ComposerProjectMessageConstants.HAND_INDEXING_PROJECT;
    private Job indexingProjectJob;

    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public void execute() {
        if (this.indexingProjectJob == null) {
            this.indexingProjectJob = new Job(INDEXING_PROJECT){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(INDEXING_PROJECT, 3);
                        EntityIndexingUtil entityIndexingUtil = EntityIndexingUtil.getInstance((ProjectEntity)ProjectController.getInstance().getCurrentProject());
                        monitor.worked(1);
                        entityIndexingUtil.doIndex();
                        monitor.worked(2);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.indexingProjectJob.setUser(true);
        }
        if (this.indexingProjectJob.getState() == 4 || this.indexingProjectJob.getState() == 2) {
            return;
        }
        if (this.indexingProjectJob.getState() == 1) {
            this.indexingProjectJob.wakeUp();
            return;
        }
        this.indexingProjectJob.schedule();
    }

    @Inject
    @Optional
    public void subscribeIndexingEvent(@UIEventTopic(value="PROJECT/INDEX") Object eventData) {
        this.execute();
    }

    @Inject
    @Optional
    public void subscribeOpenedProjectEvent(@UIEventTopic(value="PROJECT/OPENED") Object eventData) {
        this.execute();
    }

    @Inject
    @Optional
    public void subscribeRefreshAllItemEvent(@UIEventTopic(value="EXPLORER/REFRESH_ALL_ITEMS") Object eventData) {
        this.execute();
    }
}

