/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.template;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.event.CloneRemoteProjectEvent;
import com.kms.katalon.composer.project.sample.CloneSampleProjectRequest;
import com.kms.katalon.composer.project.sample.SampleLocalProject;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleProjectProvider {
    public static final String SAMPLE_WEB_UI = StringConstants.SAMPLE_WEB_UI_PROJECT;
    public static final String SAMPLE_MOBILE = StringConstants.SAMPLE_MOBILE_PROJECT;
    public static final String SAMPLE_WEB_SERVICE = StringConstants.SAMPLE_WEB_SERVICE_PROJECT;
    private static final String SAMPLE_LOCAL_TEST_SUITE_RESOURCE_NAME = StringConstants.SAMPLE_LOCAL_TEST_SUITE_RESOURCE_NAME_PROJECT;
    private static final String CHROME_PREFS_JSON = "{\"profile.password_manager_leak_detection\":false}";
    private static final String CHROME_ARGS_JSON = "[\"disable-features=LocalNetworkAccessChecks\"]";
    private static final String CHROME_SETTINGS_JSON_TEMPLATE = "{\"%s\":{\"prefs\":%s,\"args\":%s}}";
    @Inject
    private IEventBroker eventBroker;
    private final String RESOURCES_SAMPLE_PROJECTS_FOLDER = "resources" + File.separator + "samples";
    private final List<SampleLocalProject> SAMPLE_PROJECTS = Arrays.asList(SampleProjectProvider.createSampleProjectInfo(SampleProjectType.WEBUI, SAMPLE_WEB_UI, "WebUI"), SampleProjectProvider.createSampleProjectInfo(SampleProjectType.MOBILE, SAMPLE_MOBILE, "Mobile"), SampleProjectProvider.createSampleProjectInfo(SampleProjectType.WS, SAMPLE_WEB_SERVICE, "WebService"), SampleProjectProvider.createSampleProjectInfo(SampleProjectType.WEBUI, SAMPLE_WEB_UI, SAMPLE_LOCAL_TEST_SUITE_RESOURCE_NAME));
    private final EnumMap<QuickStartProjectType, ProjectType> PROJECT_TYPE_MAP = new EnumMap(QuickStartProjectType.class);
    private static SampleProjectProvider instance;
    private final Logger logger = LoggerFactory.getLogger(SampleProjectProvider.class);

    private SampleProjectProvider() {
        this.PROJECT_TYPE_MAP.put(QuickStartProjectType.WEBUI, ProjectType.WEBUI);
        this.PROJECT_TYPE_MAP.put(QuickStartProjectType.MOBILE, ProjectType.MOBILE);
        this.PROJECT_TYPE_MAP.put(QuickStartProjectType.API, ProjectType.WEBSERVICE);
        this.PROJECT_TYPE_MAP.put(QuickStartProjectType.DESKTOP, ProjectType.DESKTOP);
        this.PROJECT_TYPE_MAP.put(QuickStartProjectType.BDD, ProjectType.GENERIC);
    }

    public static SampleProjectProvider getInstance() {
        if (instance == null) {
            instance = new SampleProjectProvider();
            BundleContext bundleContext = FrameworkUtil.getBundle(SampleProjectProvider.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            ContextInjectionFactory.inject((Object)instance, (IEclipseContext)context);
        }
        return instance;
    }

    public List<SampleLocalProject> getSampleProjects() {
        return this.SAMPLE_PROJECTS;
    }

    public void extractSampleWebUIProject(SampleLocalProject sampleProject, String location) throws IOException {
        this.extractProjectSource(sampleProject.getResourceName(), location);
    }

    public void createFirstSampleProject(QuickStartProjectType quickStartProjectType) throws Exception {
        ProjectController projectController = ProjectController.getInstance();
        String name = this.getFirstProjectName(quickStartProjectType);
        String location = GlobalStringConstants.DEFAULT_PROJECT_LOCATION;
        ProjectEntity newProject = projectController.addNewProject(name, "", location, true, true, false);
        newProject.setType(this.convertToProjectType(quickStartProjectType));
        projectController.updateProject(newProject);
        projectController.openProjectForUI(newProject.getLocation(), false, null);
        this.eventBroker.post("PROJECT/OPEN", (Object)newProject.getId());
    }

    public void createFirstOnboardingSampleProject(QuickStartProjectType quickStartProjectType, String projectName, String projectLocation) throws Exception {
        ProjectController projectController = ProjectController.getInstance();
        ProjectEntity newProject = projectController.addNewProject(projectName, "", projectLocation, true, true, false);
        newProject.setType(this.convertToProjectType(quickStartProjectType));
        projectController.updateProject(newProject);
        projectController.openProjectForUI(newProject.getLocation(), false, null);
        this.eventBroker.post("PROJECT/OPEN", (Object)newProject.getId());
        if (quickStartProjectType == QuickStartProjectType.WEBUI) {
            String projectAbsoluteLocation = new File(projectLocation, projectName).getAbsolutePath();
            this.createChromeSettingsFiles(projectAbsoluteLocation);
        }
    }

    public boolean createFirstBDDSampleProject() throws Exception {
        List<SampleRemoteProject> sampleProjects = null;
        Optional<SampleRemoteProject> sampleBDDProject = null;
        if (!SampleRemoteProjectProvider.checkInternetConection()) {
            return false;
        }
        sampleProjects = SampleRemoteProjectProvider.getSampleProjects();
        sampleBDDProject = sampleProjects.stream().filter(project -> project.getSourceUrl().contains("calculator-bdd-tests")).findFirst();
        if (!sampleBDDProject.isPresent()) {
            this.createFirstSampleProject(QuickStartProjectType.BDD);
            return true;
        }
        ProjectEntity projectEntity = new ProjectEntity();
        projectEntity.setName(this.getFirstProjectName(QuickStartProjectType.BDD));
        projectEntity.setFolderLocation(new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION, projectEntity.getName()).getAbsolutePath());
        projectEntity.setType(ProjectType.GENERIC);
        ProjectController.getInstance().setOpenning(true);
        this.eventBroker.send("GIT/CLONE_REMOTE_PROJECT", (Object)new CloneRemoteProjectEvent(projectEntity, sampleBDDProject.get()));
        return true;
    }

    private static SampleLocalProject createSampleProjectInfo(SampleProjectType type, String name, String resourceFileName) {
        SampleLocalProject sampleProject = new SampleLocalProject();
        sampleProject.setType(type);
        sampleProject.setName(name);
        sampleProject.setResourceName(resourceFileName);
        return sampleProject;
    }

    private String getResourcesLocation(String projectName) {
        return this.RESOURCES_SAMPLE_PROJECTS_FOLDER + File.separator + projectName;
    }

    private void extractProjectSource(String projectName, String unzipedLocation) throws IOException {
        this.processZipFileInputStream(this.getResourceAsInputStream(this.getClass(), this.getResourcesLocation(projectName) + ".zip"), unzipedLocation);
    }

    private void processZipFileInputStream(InputStream is, String location) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                File file = new File(location, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists()) continue;
                    file.mkdirs();
                    continue;
                }
                this.writeZipEntryToFile(stream, file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeZipEntryToFile(ZipInputStream zis, File outputFile) throws IOException {
        byte[] buffer = new byte[2048];
        try (FileOutputStream output = null;){
            output = new FileOutputStream(outputFile);
            int len = 0;
            while ((len = zis.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getResourceAsInputStream(Class<?> clazz, String filePath) throws IOException {
        String projectPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(projectPath = URLDecoder.decode(projectPath, "utf-8"));
        if (jarFile.isDirectory()) {
            return new FileInputStream(new File(jarFile, filePath).getAbsolutePath());
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry jarEntry;
            Enumeration<JarEntry> entries = jar.entries();
            String relativePath = filePath.replace(File.separator, "/");
            do {
                if (entries.hasMoreElements()) continue;
                return null;
            } while (!(jarEntry = entries.nextElement()).getName().equals(relativePath));
            File extractedFile = new File(ClassPathResolver.getConfigurationFolder(), relativePath);
            FileUtils.copyInputStreamToFile((InputStream)jar.getInputStream(jarEntry), (File)extractedFile);
            return new FileInputStream(extractedFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private String getFirstProjectName(QuickStartProjectType testingType) {
        String projectName = this.getProjectNameByType(testingType);
        File firstProjectFolder = new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION);
        firstProjectFolder.mkdirs();
        return NamingUtil.getUniqueFileName((String)projectName, (String)firstProjectFolder.getAbsolutePath());
    }

    private String getProjectNameByType(QuickStartProjectType testingType) {
        switch (testingType) {
            case WEBUI: {
                return "My First Web UI Project";
            }
            case MOBILE: {
                return "My First Mobile Project";
            }
            case API: {
                return "My First API Project";
            }
            case DESKTOP: {
                return "My First Desktop Project";
            }
            case BDD: {
                return "My First BDD Project";
            }
        }
        return null;
    }

    private ProjectType convertToProjectType(QuickStartProjectType quickStartProjectType) {
        return this.PROJECT_TYPE_MAP.get(quickStartProjectType);
    }

    private void createChromeSettingsFiles(String projectLocation) {
        File settingsDir = new File(projectLocation, "settings" + File.separator + "internal");
        settingsDir.mkdirs();
        this.createChromeSettingsFile(settingsDir, "com.kms.katalon.core.webui.chrome.properties", this.buildChromeSettingsContent(WebUIDriverType.CHROME_DRIVER));
        this.createChromeSettingsFile(settingsDir, "com.kms.katalon.core.webui.chrome (headless).properties", this.buildChromeSettingsContent(WebUIDriverType.HEADLESS_DRIVER));
    }

    private void createChromeSettingsFile(File settingsDir, String fileName, String content) {
        File settingsFile = new File(settingsDir, fileName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream fos = new FileOutputStream(settingsFile);){
                fos.write(content.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String errorMessage = MessageFormat.format(ComposerProjectMessageConstants.ERROR_MSG_FAILED_TO_CREATE_CHROME_SETTINGS_FILE, fileName, e.getMessage());
            LoggerSingleton.logError((String)errorMessage);
        }
    }

    private String buildChromeSettingsContent(WebUIDriverType driverType) {
        return String.format(CHROME_SETTINGS_JSON_TEMPLATE, driverType.getName(), CHROME_PREFS_JSON, CHROME_ARGS_JSON);
    }

    public void performRemoteClone(CloneSampleProjectRequest request) throws Exception {
        try {
            SampleRemoteProject remoteProject = this.createSampleRemoteProject(request);
            ProjectEntity projectEntity = this.createProjectEntity(request);
            CloneRemoteProjectEvent cloneEvent = new CloneRemoteProjectEvent(projectEntity, remoteProject);
            this.eventBroker.send("GIT/CLONE_REMOTE_PROJECT", (Object)cloneEvent);
            this.trustProjectWhenCreated(request.getProjectLocation());
        }
        catch (Exception e) {
            this.logger.error("Failed to initiate remote clone for project: {}", (Object)request.getProjectName(), (Object)e);
            throw new Exception("Remote clone failed: " + e.getMessage(), e);
        }
    }

    public void performLocalClone(CloneSampleProjectRequest request) throws Exception {
        try {
            SampleLocalProject localProject = this.getSampleProjects().stream().filter(project -> project.getType() == SampleProjectType.WEBUI && project.getResourceName().equals(request.getLocalResourceName())).findFirst().orElseThrow(() -> new Exception("Local sample project not found: " + request.getLocalResourceName()));
            this.extractSampleWebUIProject(localProject, request.getProjectLocation());
            this.openAndTrustProject(request.getProjectLocation());
        }
        catch (Exception e) {
            this.logger.error("Failed to create local fallback project: {}", (Object)request.getProjectName(), (Object)e);
            this.cleanupProjectDirectory(request.getProjectLocation());
            throw new Exception("Local clone failed: " + e.getMessage(), e);
        }
    }

    private void cleanupProjectDirectory(String projectLocation) {
        try {
            File projectDir = new File(projectLocation);
            if (projectDir.exists()) {
                FileUtils.deleteDirectory((File)projectDir);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to cleanup project directory: {}", (Object)projectLocation, (Object)e);
        }
    }

    private SampleRemoteProject createSampleRemoteProject(CloneSampleProjectRequest request) {
        SampleRemoteProject remoteProject = new SampleRemoteProject();
        remoteProject.setSourceUrl(request.getRemoteUrl());
        remoteProject.setType(SampleProjectType.WEBUI);
        remoteProject.setDefaultBranch(request.getBranch());
        return remoteProject;
    }

    private ProjectEntity createProjectEntity(CloneSampleProjectRequest request) {
        ProjectEntity projectEntity = new ProjectEntity();
        projectEntity.setName(request.getProjectName());
        projectEntity.setFolderLocation(request.getProjectLocation());
        projectEntity.setType(this.convertToProjectType(request.getQuickStartProjectType()));
        return projectEntity;
    }

    private void openAndTrustProject(String projectLocation) throws Exception {
        ProjectController controller = ProjectController.getInstance();
        File projectFile = controller.getProjectFile(projectLocation);
        ProjectEntity projectEntity = controller.getProject(projectFile.getAbsolutePath());
        controller.trustProject(projectEntity);
        this.eventBroker.post("PROJECT/OPEN", (Object)projectFile.getAbsolutePath());
    }

    private void trustProjectWhenCreated(final String projectLocation) {
        this.eventBroker.subscribe("PROJECT/CREATED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                ProjectEntity createdProject = (ProjectEntity)this.getObject(event);
                if (SampleProjectProvider.this.isMatchingProject(createdProject, projectLocation)) {
                    SampleProjectProvider.this.trustProjectAndUnsubscribeEvent(createdProject, this);
                }
            }
        });
    }

    private boolean isMatchingProject(ProjectEntity project, String projectLocation) {
        return project != null && project.getFolderLocation().equals(projectLocation);
    }

    private void trustProjectAndUnsubscribeEvent(ProjectEntity project, EventServiceAdapter adapter) {
        try {
            ProjectController.getInstance().trustProject(project);
            this.eventBroker.unsubscribe((EventHandler)adapter);
        }
        catch (Exception e) {
            this.logger.error("Failed to trust project: " + e.getMessage(), (Throwable)e);
        }
    }
}

