/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.views;

import com.kms.katalon.composer.project.constants.ImageConstants;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.views.ResizableProjectPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewTemplateProjectPage
extends ResizableProjectPage {
    private Composite container;
    private Table table;

    public NewTemplateProjectPage() {
        super(StringConstants.VIEW_TESTING_TYPES_PROJECT_PAGE_NAME);
        this.setTitle(StringConstants.VIEW_TITLE_NEW_PROJ);
        this.setDescription(StringConstants.VIEW_MSG_SPECIFY_TESTING_TYPES);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.container.setLayoutData((Object)new GridData(1808));
        this.table = new Table(this.container, 2848);
        this.table.setLayoutData((Object)new GridData(1808));
        this.createItem(this.table, StringConstants.VIEW_LBL_WEB_TESTING, ImageConstants.WEB_ICON, true);
        this.createItem(this.table, StringConstants.VIEW_LBL_MOBILE_TESTING, ImageConstants.MOBILE_ICON, true);
        this.createItem(this.table, StringConstants.VIEW_LBL_API_TESTING, ImageConstants.API_ICON, true);
        this.addCheckListener(this.table);
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void createItem(Table table, String label, Image icon, boolean isChecked) {
        TableItem item = new TableItem(table, 0);
        item.setText(label);
        item.setImage(icon);
        item.setChecked(isChecked);
    }

    private void addCheckListener(final Table table) {
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        NewTemplateProjectPage.this.setPageComplete(true);
                        return;
                    }
                    ++n2;
                }
                NewTemplateProjectPage.this.setPageComplete(false);
            }
        });
    }

    public List<String> getSelectedTemplates() {
        ArrayList<String> selectedOptions = new ArrayList<String>();
        int i = 0;
        while (i < this.table.getItems().length) {
            if (this.table.getItems()[i].getChecked()) {
                selectedOptions.add(this.table.getItems()[i].getText());
            }
            ++i;
        }
        return selectedOptions;
    }

    @Override
    public Point getPageSize() {
        return new Point(550, 250);
    }
}

