/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.XMLUnit;
import org.reficio.ws.SoapException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static Set<String> getNodeNames(Set<Node> nodes) {
        HashSet<String> names = new HashSet<String>();
        for (Node node : nodes) {
            names.add(node.getLocalName());
        }
        return names;
    }

    public static Set<QName> getNodeTypes(Set<Node> nodes) {
        HashSet<QName> names = new HashSet<QName>();
        for (Node node : nodes) {
            names.add(XmlUtils.nodeToQName(node));
        }
        return names;
    }

    public static Set<Node> getRootNodes(DOMSource request) {
        return XmlUtils.populateNodes(request.getNode(), new HashSet<Node>());
    }

    public static Set<Node> populateNodes(Node node, Set<Node> nodes) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                nodes.add(node);
            }
            XmlUtils.populateNodes(node.getNextSibling(), nodes);
        }
        return nodes;
    }

    public static QName nodeToQName(Node node) {
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static Source xmlStringToSource(String xmlString) {
        StringReader reader = new StringReader(xmlString);
        InputSource src = new InputSource(reader);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(src);
            DOMSource xmlSource = new DOMSource(dom);
            return xmlSource;
        }
        catch (ParserConfigurationException ex) {
            throw new SoapException(ex);
        }
        catch (SAXException ex) {
            throw new SoapException(ex);
        }
        catch (IOException ex) {
            throw new SoapException(ex);
        }
    }

    public static String sourceToXmlString(Source xmlSource) {
        if (xmlSource == null) {
            return "";
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(xmlSource, new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new SoapException("Error during XML transformer configuration", e);
        }
        catch (TransformerException e) {
            throw new SoapException("Error during XML source transformation", e);
        }
    }

    public static String serializePretty(Document document) {
        try {
            StringWriter out = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (TransformerConfigurationException e) {
            throw new SoapException("Failed to serialize: ", e);
        }
        catch (TransformerException e) {
            throw new SoapException("Failed to serialize: ", e);
        }
    }

    public static String normalizeAndRemoveValues(String xmlContent) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setCoalescing(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new ByteArrayInputStream(xmlContent.getBytes()));
            document.normalizeDocument();
            XmlUtils.processNode(document);
            return XmlUtils.serializePretty(document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void processNode(Node node) throws Exception {
        if (node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                XmlUtils.processNode(child);
            }
        } else {
            node.setTextContent(" ");
        }
    }

    public static boolean isIdenticalNormalizedWithoutValues(String expected, String current) {
        String expectedProcessed = XmlUtils.normalizeAndRemoveValues(expected);
        String currentProcessed = XmlUtils.normalizeAndRemoveValues(current);
        try {
            return XMLUnit.compareXML((String)expectedProcessed, (String)currentProcessed).identical();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

