/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.qas.api.http.FastUrlEncoder;
import org.qas.api.internal.util.google.base.Charsets;
import org.qas.api.internal.util.google.base.Preconditions;

public final class UrlEncoder {
    public static final Charset DEFAULT_ENCODING = Charsets.UTF_8;

    private UrlEncoder() {
        throw new AssertionError((Object)"UrlEncoder utility class must not be instantiated.");
    }

    public static String encode(String source) {
        return UrlEncoder.encode(source, DEFAULT_ENCODING);
    }

    public static String encode(String source, Charset encoding) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(encoding);
        try {
            return FastUrlEncoder.urlEncode(source, encoding.name());
        }
        catch (UnsupportedEncodingException ueex) {
            throw new AssertionError((Object)ueex);
        }
    }

    public static String decode(String source) {
        return UrlEncoder.decode(source, DEFAULT_ENCODING);
    }

    public static String decode(String source, Charset encoding) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(encoding);
        try {
            return URLDecoder.decode(source, encoding.name());
        }
        catch (UnsupportedEncodingException uuex) {
            throw new AssertionError((Object)uuex);
        }
    }
}

