/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.qas.api.ClientConfiguration;
import org.qas.api.http.Protocol;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.services.design.TestDesignServiceAsync;
import org.qas.qtest.api.services.design.TestDesignServiceAsyncClient;
import org.qas.qtest.api.services.design.model.ListTestCaseRequest;
import org.qas.qtest.api.services.design.model.TestCase;

public class Main {
    protected static final String CONFIG_FILE = "qtest-test.properties";
    private static TestDesignServiceAsync testDesignService;
    private static Long projectId;

    public static void main(String[] args) throws Exception {
        if (testDesignService == null) {
            testDesignService = Main.createTestDesignService();
        }
        ListTestCaseRequest testCaseRequest = new ListTestCaseRequest().withProjectId(20799L);
        testCaseRequest.withPage(1L);
        List<TestCase> testcases = testDesignService.listTestCase(testCaseRequest);
        System.out.println("Size = " + testcases.size());
        for (TestCase tc : testcases) {
            System.out.println(tc);
        }
    }

    protected static TestDesignServiceAsync createTestDesignService() throws IOException {
        ClientConfiguration clientConfiguration = Main.createClientConfiguration();
        return new TestDesignServiceAsyncClient(Main.getCredentials(clientConfiguration), clientConfiguration);
    }

    protected static ClientConfiguration createClientConfiguration() throws IOException {
        InputStream inputStream = ClientConfiguration.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        if (inputStream == null) {
            throw new FileNotFoundException("qtest-test.properties not found on classpath.");
        }
        Properties configuration = new Properties();
        configuration.load(inputStream);
        ClientConfiguration clientConfig = new ClientConfiguration().withProtocol(Protocol.valueOf(configuration.getProperty("client.protocol", "HTTP"))).withMaxConnections(Integer.parseInt(configuration.getProperty("client.max-connection", "10"), 10)).withMaxErrorRetry(Integer.parseInt(configuration.getProperty("client.max-error-retry", "3"), 10)).withProperty("service.endpoint", configuration.getProperty("service.endpoint", "nephele.qtestnet.com")).withProperty("qTest.projectId", Long.parseLong(configuration.getProperty("qTest.projectId", "-1"), 10)).withProperty("qTest.token", configuration.getProperty("qTest.token")).withProperty("qTest.engineClass", configuration.getProperty("qTest.engineClass"));
        projectId = (Long)clientConfig.getProperty("qTest.projectId");
        return clientConfig;
    }

    protected static Long getProjectId() {
        return projectId == null ? 1L : projectId;
    }

    protected static QTestCredentials getCredentials(ClientConfiguration clientConfiguration) {
        return new BasicQTestCredentials((String)clientConfiguration.getProperty("qTest.token"));
    }

    static {
        projectId = -1L;
    }
}

