/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.qas.api.DateTimeDeserializer;
import org.qas.api.DateTimeSerializer;
import org.qas.api.internal.util.google.collect.Lists;
import org.qas.qtest.api.internal.model.QTestBaseModel;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.execution.model.ExecutionStatus;
import org.qas.qtest.api.services.execution.model.TestStepLog;

public class TestLog
extends QTestBaseModel<TestLog> {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="status")
    private ExecutionStatus status;
    @JsonProperty(value="test_case_version_id")
    private Long testCaseVersionId;
    @JsonProperty(value="exe_start_date")
    private Date executionStartDate;
    @JsonProperty(value="exe_end_date")
    private Date executionEndDate;
    @JsonProperty(value="user_id")
    private Long userId;
    @JsonProperty(value="note")
    private String note;
    @JsonProperty(value="class_name")
    private String className;
    @JsonProperty(value="test_case")
    private TestCase testCase;
    @JsonProperty(value="test_step_logs")
    private List<TestStepLog> testStepLogs;
    @JsonProperty(value="attachments")
    private List<Attachment> attachments;
    @JsonProperty(value="build_number")
    private String buildNumber;
    @JsonProperty(value="build_url")
    private String buildUrl;

    public Long getId() {
        return this.id;
    }

    public TestLog setId(Long id) {
        this.id = id;
        return this;
    }

    public TestLog withId(Long id) {
        this.setId(id);
        return this;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public TestLog setStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    public TestLog withStatus(ExecutionStatus status) {
        this.setStatus(status);
        return this;
    }

    public Long getTestCaseVersionId() {
        return this.testCaseVersionId;
    }

    public TestLog setTestCaseVersionId(Long testCaseVersionId) {
        this.testCaseVersionId = testCaseVersionId;
        return this;
    }

    public TestLog withTestCaseVersionId(Long testCaseVersionId) {
        this.setTestCaseVersionId(testCaseVersionId);
        return this;
    }

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public TestLog setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
        return this;
    }

    public TestLog withExecutionStartDate(Date executionStartDate) {
        this.setExecutionStartDate(executionStartDate);
        return this;
    }

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public TestLog setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
        return this;
    }

    public TestLog withExecutionEndDate(Date executionEndDate) {
        this.setExecutionEndDate(executionEndDate);
        return this;
    }

    public Long getUserId() {
        return this.userId;
    }

    public TestLog setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public TestLog withUserId(Long userId) {
        this.setUserId(userId);
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public TestLog setNote(String note) {
        this.note = note;
        return this;
    }

    public TestLog withNote(String note) {
        this.setNote(note);
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public TestLog setClassName(String className) {
        this.className = className;
        return this;
    }

    public TestLog withClassName(String className) {
        this.setClassName(className);
        return this;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public TestLog setTestCase(TestCase testCase) {
        this.testCase = testCase;
        return this;
    }

    public TestLog withTestCase(TestCase testCase) {
        this.setTestCase(testCase);
        return this;
    }

    public List<TestStepLog> getTestStepLogs() {
        if (null == this.testStepLogs) {
            return Collections.emptyList();
        }
        return this.testStepLogs;
    }

    public TestLog setTestStepLogs(List<TestStepLog> testStepLogs) {
        this.testStepLogs = testStepLogs;
        return this;
    }

    public TestLog withTestStepLogs(List<TestStepLog> testStepLogs) {
        this.setTestStepLogs(testStepLogs);
        return this;
    }

    public TestLog addTestStepLog(TestStepLog testStepLog) {
        if (this.testStepLogs == null) {
            this.testStepLogs = Lists.newLinkedList();
        }
        this.testStepLogs.add(testStepLog);
        return this;
    }

    public List<Attachment> getAttachments() {
        if (null == this.attachments) {
            return Collections.emptyList();
        }
        return this.attachments;
    }

    public TestLog setAttachments(List<Attachment> attachments) {
        this.attachments = attachments == null || attachments.size() == 0 ? null : attachments;
        return this;
    }

    public TestLog withAttachments(List<Attachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public TestLog addAttachment(Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachment);
        return this;
    }

    @Override
    protected TestLog clone() {
        TestLog that = new TestLog();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    public String elementName() {
        return "test-log";
    }

    @Override
    public String jsonElementName() {
        return "test_log";
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public TestLog setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public TestLog withBuildNumber(String buildNumber) {
        return this.setBuildNumber(buildNumber);
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public TestLog setBuildUrl(String buildUrl) {
        this.buildUrl = buildUrl;
        return this;
    }

    public TestLog withBuildUrl(String buildUrl) {
        return this.setBuildUrl(buildUrl);
    }
}

