/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.CreateTestRunRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestRunRequestMarshaller;

public final class CreateTestRunRequestMarshaller
extends AbstractTestRunRequestMarshaller<CreateTestRunRequest> {
    @Override
    public Request marshall(CreateTestRunRequest testRunRequest) throws Exception {
        testRunRequest = ApiPreconditions.notNull(testRunRequest);
        CreateTestRunRequestMarshaller.validateProjectId(testRunRequest.getProjectId());
        CreateTestRunRequestMarshaller.validateArtifactLevel(testRunRequest.getArtifactLevel());
        CreateTestRunRequestMarshaller.validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());
        ApiPreconditions.notNull(testRunRequest.getTestRun(), "Invalid test-run passed to marshall(...)");
        Request request = this.createJsonRequest(testRunRequest, "CreateTestRun", HttpMethod.POST);
        if (testRunRequest.getExternalToken() != null) {
            request.setHeader("X-External-Token", testRunRequest.getExternalToken());
        }
        request.setResourcePath(this.createApiPathBuilder(testRunRequest.getProjectId()).toString());
        if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId()));
            request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());
        }
        request.setContent(new StringInputStream(JsonMapper.toJson(testRunRequest.getTestRun())));
        return request;
    }
}

