/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.CreateTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestSuiteRequestMarshaller;

public final class CreateTestSuiteRequestMarshaller
extends AbstractTestSuiteRequestMarshaller<CreateTestSuiteRequest> {
    @Override
    public Request marshall(CreateTestSuiteRequest testSuiteRequest) throws Exception {
        testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
        CreateTestSuiteRequestMarshaller.validateProjectId(testSuiteRequest.getProjectId());
        ApiPreconditions.notNull(testSuiteRequest.getTestSuite(), "Invalid test-suite passed to marshall(...)");
        CreateTestSuiteRequestMarshaller.validateArtifactLevel(testSuiteRequest.getArtifactLevel());
        CreateTestSuiteRequestMarshaller.validateArtifact(testSuiteRequest.getArtifactLevel(), testSuiteRequest.getArtifactId());
        Request request = this.createJsonRequest(testSuiteRequest, "CreateTestSuite", HttpMethod.POST);
        request.setResourcePath(this.createApiPathBuilder(testSuiteRequest.getProjectId()).toString());
        if (testSuiteRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testSuiteRequest.getArtifactId()));
            request.addParameter("parentType", testSuiteRequest.getArtifactLevel().getQueryParam());
        }
        request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
        return request;
    }
}

