/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.ListTestCycleRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestCycleRequestMarshaller;

public final class ListTestCycleRequestMarshaller
extends AbstractTestCycleRequestMarshaller<ListTestCycleRequest> {
    @Override
    public Request marshall(ListTestCycleRequest testCycleRequest) throws Exception {
        testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
        ListTestCycleRequestMarshaller.validateProjectId(testCycleRequest.getProjectId());
        ListTestCycleRequestMarshaller.validateArtifactLevel(testCycleRequest.getArtifactLevel());
        ListTestCycleRequestMarshaller.validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());
        Request request = this.createJsonRequest(testCycleRequest, "ListTestCycle", HttpMethod.GET);
        request.setResourcePath(this.createApiPathBuilder(testCycleRequest.getProjectId()).toString());
        if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
            request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());
        }
        if (testCycleRequest.isIncludeDescendants()) {
            request.addParameter("expand", "descendants");
        }
        return request;
    }
}

