/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.ListTestRunRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestRunRequestMarshaller;

public final class ListTestRunRequestMarshaller
extends AbstractTestRunRequestMarshaller<ListTestRunRequest> {
    @Override
    public Request marshall(ListTestRunRequest testRunRequest) throws Exception {
        testRunRequest = ApiPreconditions.notNull(testRunRequest);
        ListTestRunRequestMarshaller.validateProjectId(testRunRequest.getProjectId());
        ListTestRunRequestMarshaller.validateArtifactLevel(testRunRequest.getArtifactLevel());
        ListTestRunRequestMarshaller.validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());
        Request request = this.createJsonRequest(testRunRequest, "ListTestRun", HttpMethod.GET);
        request.setResourcePath(this.createApiPathBuilder(testRunRequest.getProjectId()).toString());
        if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId()));
            request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());
        }
        return request;
    }
}

