/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.UpdateTestCycleRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestCycleRequestMarshaller;

public final class UpdateTestCycleRequestMarshaller
extends AbstractTestCycleRequestMarshaller<UpdateTestCycleRequest> {
    @Override
    public Request marshall(UpdateTestCycleRequest testCycleRequest) throws Exception {
        testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
        UpdateTestCycleRequestMarshaller.validateProjectId(testCycleRequest.getProjectId());
        ApiPreconditions.notNull(testCycleRequest.getTestCycle(), "Invalid test-cycle data passed to marshall(...)");
        Long testCycleId = testCycleRequest.getTestCycleId() != null ? testCycleRequest.getTestCycleId() : testCycleRequest.getTestCycle().getId();
        UpdateTestCycleRequestMarshaller.validateTestCycleId(testCycleId);
        testCycleRequest.getTestCycle().setId(testCycleId);
        Request request = this.createJsonRequest(testCycleRequest, "UpdateTestCycle", HttpMethod.PUT);
        StringBuilder builder = this.createApiPathBuilder(testCycleRequest.getProjectId());
        builder.append('/').append(testCycleId);
        request.setResourcePath(builder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));
        return request;
    }
}

