/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.UpdateAutomationAgentRequest;

public class UpdateAutomationAgentRequestMarshaller
extends AbstractMarshaller<Request, UpdateAutomationAgentRequest> {
    @Override
    protected void validateRequest(UpdateAutomationAgentRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getAgent() == null || in.getAgent().getAgentServerId() == null) {
            throw new AuthClientException("Invalid agent instance passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, UpdateAutomationAgentRequest in) {
        request.setHttpMethod(HttpMethod.PUT);
    }

    @Override
    protected String getServiceName() {
        return "HostService";
    }

    @Override
    protected String getActionName() {
        return "UpdateAgent";
    }

    @Override
    protected String getContent(UpdateAutomationAgentRequest in) throws Exception {
        return JsonMapper.toJson(in.getAgent());
    }

    @Override
    protected StringBuilder getResourcePath(UpdateAutomationAgentRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/automation/hosts/").append(in.getAgent().getHostId()).append("/agents/").append(in.getAgent().getAgentServerId());
    }
}

