/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.qas.api.DateTimeDeserializer;
import org.qas.api.DateTimeSerializer;
import org.qas.api.JsonMapper;
import org.qas.qtest.api.internal.model.QTestBaseModel;
import org.qas.qtest.api.services.project.model.DefectTrackingSystem;

public final class Project
extends QTestBaseModel<Project> {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="sample")
    private Boolean sample;
    @JsonProperty(value="start_date")
    private Date startDate;
    @JsonProperty(value="end_date")
    private Date endDate;
    @JsonProperty(value="defect_tracking_systems")
    private List<DefectTrackingSystem> defectTrackingSystems;

    public Project() {
        this.setSample(Boolean.FALSE);
    }

    public Long getId() {
        return this.id;
    }

    public Project setId(Long id) {
        this.id = id;
        return this;
    }

    public Project withId(Long id) {
        this.setId(id);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Project setName(String name) {
        this.name = name;
        return this;
    }

    public Project withName(String name) {
        this.setName(name);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    public Project withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Boolean isSample() {
        return this.sample;
    }

    public Project setSample(Boolean sample) {
        this.sample = sample == null ? Boolean.FALSE : sample;
        return this;
    }

    public Project withSample(Boolean sample) {
        this.setSample(sample);
        return this;
    }

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getStartDate() {
        return this.startDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public Project setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public Project withStartDate(Date startDate) {
        this.setStartDate(startDate);
        return this;
    }

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getEndDate() {
        return this.endDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public Project setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public Project withEndDate(Date startDate) {
        this.setEndDate(startDate);
        return this;
    }

    public List<DefectTrackingSystem> getDefectTrackingSystems() {
        if (this.defectTrackingSystems == null) {
            return Collections.emptyList();
        }
        return this.defectTrackingSystems;
    }

    public Project setDefectTrackingSystems(List<DefectTrackingSystem> dtses) {
        this.defectTrackingSystems = dtses;
        return this;
    }

    public Project withDefectTrackingSystems(List<DefectTrackingSystem> dtses) {
        this.setDefectTrackingSystems(dtses);
        return this;
    }

    public Project addDefectTrackingSystem(DefectTrackingSystem dts) {
        if (this.defectTrackingSystems == null) {
            this.defectTrackingSystems = new LinkedList<DefectTrackingSystem>();
        }
        this.defectTrackingSystems.add(dts);
        return this;
    }

    @Override
    @JsonIgnore
    public Project clone() {
        Project that = new Project();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    @JsonIgnore
    public String elementName() {
        return "project";
    }

    @Override
    public String toString() {
        return JsonMapper.toJson(this);
    }
}

