/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.handler;

import cucumber.eclipse.editor.controller.CucumberController;
import cucumber.eclipse.editor.handler.CucumberEventHandler;
import cucumber.eclipse.editor.handler.OnFileChangeListener;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.event.Event;

public class OpenProjectHandler
extends CucumberEventHandler {
    private Job loadBDDScriptsJob;
    private IResourceChangeListener onFileChangeListener;

    public OpenProjectHandler() {
        super("PROJECT/LOAD_BDD", "PROJECT/BDD/CLOSE");
    }

    public void handleEvent(Event event) {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!event.getTopic().equals("PROJECT/LOAD_BDD")) {
            if (this.onFileChangeListener != null) {
                if (this.loadBDDScriptsJob != null) {
                    this.loadBDDScriptsJob.cancel();
                }
                workspace.removeResourceChangeListener(this.onFileChangeListener);
            }
            return;
        }
        String projectPath = (String)event.getProperty("org.eclipse.e4.data");
        final IProject project = this.getProject(projectPath);
        this.loadBDDScriptsJob = new Job("Loading BDD scripts..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new CucumberController().fullBuild(project, monitor);
                    OpenProjectHandler.this.onFileChangeListener = new OnFileChangeListener(project.getName());
                    workspace.addResourceChangeListener(OpenProjectHandler.this.onFileChangeListener, 1);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "cucumber.eclipse.editor.builder", "Unable to load Cucumber scripts");
                }
            }
        };
        this.loadBDDScriptsJob.schedule();
    }

    private IProject getProject(String projectPath) {
        String projectId = projectPath.replace(File.separator, "%").replace(":", "%");
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }
}

