/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps;

import cucumber.eclipse.editor.steps.StorageHelper;
import cucumber.eclipse.steps.integration.ExpressionDefinition;
import cucumber.eclipse.steps.integration.GherkinStepWrapper;
import cucumber.eclipse.steps.integration.Glue;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import gherkin.I18n;
import gherkin.formatter.model.Step;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GlueRepository
implements Externalizable {
    private static final long serialVersionUID = -3784224573706686779L;
    private final Map<GherkinStepWrapper, StepDefinition> glues = new ConcurrentHashMap<GherkinStepWrapper, StepDefinition>();
    private transient Map<StepDefinition, ParsedExpression> expressionCache;
    private transient IProject project;

    protected GlueRepository(IProject project) {
        this.project = project;
    }

    public Glue get(GherkinStepWrapper gherkinStep) {
        StepDefinition stepDefinition = this.glues.get(gherkinStep);
        if (stepDefinition == null) {
            return null;
        }
        return new Glue(gherkinStep, stepDefinition);
    }

    public Glue add(GherkinStepWrapper gherkinStep, StepDefinition stepDefinition) {
        this.glues.put(gherkinStep, stepDefinition);
        return new Glue(gherkinStep, stepDefinition);
    }

    public Set<IFile> getGherkinSources() {
        HashSet<IFile> gherkinSources = new HashSet<IFile>();
        for (GherkinStepWrapper gherkinStep : this.glues.keySet()) {
            gherkinSources.add((IFile)gherkinStep.getSource());
        }
        return gherkinSources;
    }

    public Set<IFile> getStepDefinitionsSources() {
        HashSet<IFile> stepDefinitionsSources = new HashSet<IFile>();
        for (StepDefinition stepDefinition : this.glues.values()) {
            stepDefinitionsSources.add((IFile)stepDefinition.getSource());
        }
        return stepDefinitionsSources;
    }

    public Glue findGlue(String fromGherkinStepText) {
        Map.Entry<GherkinStepWrapper, StepDefinition> glue = null;
        Set<Map.Entry<GherkinStepWrapper, StepDefinition>> entrySet = this.glues.entrySet();
        for (Map.Entry<GherkinStepWrapper, StepDefinition> entry : entrySet) {
            GherkinStepWrapper gherkinStepWrapper = entry.getKey();
            Step gherkinStep = gherkinStepWrapper.getStep();
            String regex = String.valueOf(Pattern.quote(gherkinStep.getKeyword())) + "[ ]*" + Pattern.quote(gherkinStep.getName());
            if (!Pattern.matches(regex, fromGherkinStepText)) continue;
            glue = entry;
            break;
        }
        if (glue == null) {
            return null;
        }
        return new Glue((GherkinStepWrapper)glue.getKey(), (StepDefinition)glue.getValue());
    }

    public void clean() {
        this.glues.clear();
    }

    public void clean(Step step) {
        for (GherkinStepWrapper gherkinStepWrapper : this.glues.keySet()) {
            Integer lineNumber = gherkinStepWrapper.getStep().getLine();
            if (!step.getLine().equals(lineNumber)) continue;
            this.glues.remove(gherkinStepWrapper);
            this.clearExpressionCache(gherkinStepWrapper);
            break;
        }
    }

    public void clean(IResource gherkinFile) {
        Iterator<GherkinStepWrapper> iterator = this.glues.keySet().iterator();
        while (iterator.hasNext()) {
            GherkinStepWrapper wrapper = iterator.next();
            if (!wrapper.getSource().equals((Object)gherkinFile)) continue;
            iterator.remove();
            this.clearExpressionCache(wrapper);
        }
    }

    private void clearExpressionCache(GherkinStepWrapper wrapper) {
        Step step = wrapper.getStep();
        if (step != null) {
            this.getExpressionCache().remove(step);
        }
    }

    protected String getTextStatement(String language, String expression) {
        Matcher matcher = this.getBasicStatementMatcher(language, expression);
        if (matcher == null) {
            return null;
        }
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private Matcher getBasicStatementMatcher(String language, String text) {
        Pattern cukePattern = this.getLanguageKeyWordMatcher(language);
        if (cukePattern == null) {
            return null;
        }
        return cukePattern.matcher(text.trim());
    }

    protected Pattern getLanguageKeyWordMatcher(String languageCode) {
        try {
            if (languageCode == null) {
                languageCode = "en";
            }
            I18n i18n = new I18n(languageCode);
            StringBuilder sb = new StringBuilder();
            sb.append("(?:");
            String delim = "";
            for (String keyWord : i18n.getStepKeywords()) {
                sb.append(delim).append(Pattern.quote(keyWord));
                delim = "|";
            }
            return Pattern.compile(sb.append(")(.*)$").toString());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.glues.clear();
        int items = in.readInt();
        int i = 0;
        while (i < items) {
            GherkinStepWrapper wrapper = (GherkinStepWrapper)in.readObject();
            this.glues.put(wrapper, StorageHelper.readStepDefinition(in));
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.glues.size());
        for (Map.Entry<GherkinStepWrapper, StepDefinition> entry : this.glues.entrySet()) {
            out.writeObject(entry.getKey());
            StorageHelper.writeStepDefinition(entry.getValue(), out);
        }
    }

    public synchronized StepDefinition findMatchingStep(Set<StepDefinition> stepDefinitionsScope, String text) {
        Map<StepDefinition, ParsedExpression> cache = this.getExpressionCache();
        for (StepDefinition stepDefinition : stepDefinitionsScope) {
            ParsedExpression expression = cache.get(stepDefinition);
            if (expression == null) {
                expression = new ParsedExpression(stepDefinition, this.getExpressionFactory(stepDefinition.getExpression()), false);
                cache.putIfAbsent(stepDefinition, expression);
            } else if (expression.getExpression() != null) {
                expression = new ParsedExpression(stepDefinition, this.getExpressionFactory(stepDefinition.getExpression()), true);
            }
            if (!expression.matches(text)) continue;
            return stepDefinition;
        }
        return null;
    }

    private ExpressionFactory getExpressionFactory(ExpressionDefinition expression) {
        Object adapter;
        if (this.project != null && (adapter = AdapterManager.getDefault().loadAdapter((Object)this.project, ExpressionFactory.class.getName())) instanceof ExpressionFactory) {
            return (ExpressionFactory)adapter;
        }
        String lang = expression.getLang();
        Locale locale = lang == null ? Locale.getDefault() : new Locale(lang);
        return new ExpressionFactory(new ParameterTypeRegistry(locale));
    }

    private synchronized Map<StepDefinition, ParsedExpression> getExpressionCache() {
        if (this.expressionCache == null) {
            this.expressionCache = new ConcurrentHashMap<StepDefinition, ParsedExpression>();
        }
        return this.expressionCache;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static final class ParsedExpression {
        Expression cucumberExpression;

        public ParsedExpression(StepDefinition step, ExpressionFactory factory, boolean isSilent) {
            block3: {
                ExpressionDefinition definition = step.getExpression();
                String text = definition.getText();
                try {
                    this.cucumberExpression = factory.createExpression(text);
                }
                catch (CucumberExpressionException | PatternSyntaxException e) {
                    if (isSilent) {
                        return;
                    }
                    IResource source = step.getSource();
                    int lineNumber = step.getLineNumber();
                    if (source == null) break block3;
                    MarkerFactory.INSTANCE.syntaxErrorOnStepDefinition(source, (Exception)e, lineNumber);
                }
            }
        }

        public boolean matches(String text) {
            return this.cucumberExpression != null && this.cucumberExpression.match(text, new Type[0]) != null;
        }

        public Expression getExpression() {
            return this.cucumberExpression;
        }
    }
}

