/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.steps.BuildStorage;
import cucumber.eclipse.editor.steps.GlueRepository;
import cucumber.eclipse.editor.steps.StorageHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IFileEditorInput;

public class GlueStorage
implements BuildStorage<GlueRepository> {
    public static final BuildStorage<GlueRepository> INSTANCE = new GlueStorage();
    private static final String BUILD_FILE = "cucumber.glue.tmp";
    private Map<IProject, GlueRepository> glueRepositoryByProject = new HashMap<IProject, GlueRepository>();
    private boolean isInitialized = false;

    private GlueStorage() {
    }

    @Override
    public synchronized GlueRepository getOrCreate(IProject project, IProgressMonitor monitor) throws CoreException {
        GlueRepository glueRepository = this.glueRepositoryByProject.get(project);
        if (glueRepository == null) {
            glueRepository = new GlueRepository(project);
            this.add(project, glueRepository);
        }
        return glueRepository;
    }

    @Override
    public void add(IProject project, GlueRepository glueRepository) {
        this.glueRepositoryByProject.put(project, glueRepository);
    }

    public static GlueRepository findGlueRepository(Editor editor) throws CoreException {
        IFileEditorInput fileEditorInput = (IFileEditorInput)editor.getEditorInput();
        IProject project = fileEditorInput.getFile().getProject();
        return INSTANCE.getOrCreate(project, null);
    }

    @Override
    public void persist(IProject project, IProgressMonitor monitor) throws CoreException {
        GlueRepository glueRepository = this.glueRepositoryByProject.get(project);
        if (glueRepository == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = StorageHelper.toStream(glueRepository, (IProgressMonitor)subMonitor.newChild(50));){
                StorageHelper.saveIntoBuildDirectory(BUILD_FILE, project, (IProgressMonitor)subMonitor.newChild(50), stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void load(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder outputFolder = StorageHelper.getOutputFolder(project);
        if (!outputFolder.exists()) {
            return;
        }
        IFile buildFile = outputFolder.getFile(BUILD_FILE);
        if (!buildFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (InputStream inputStream = buildFile.getContents();){
                GlueRepository glueRepository = StorageHelper.fromStream(GlueRepository.class, inputStream, monitor);
                glueRepository.setProject(project);
                this.glueRepositoryByProject.put(project, glueRepository);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", "loading StepDefinitionStore failed, a full rebuild of the project might be required", (Throwable)e));
            this.glueRepositoryByProject.put(project, new GlueRepository(project));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", "loading GlueStore failed, a full rebuild of the project might be required", (Throwable)e));
            this.glueRepositoryByProject.put(project, new GlueRepository(project));
        }
        catch (ClassNotFoundException e) {
            this.glueRepositoryByProject.put(project, new GlueRepository(project));
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", "loading GlueStore failed, a full rebuild of the project might be required", (Throwable)e));
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }
}

