/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.launching;

import cucumber.eclipse.launching.CucumberFeatureLaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CucumberMainTab
extends SharedJavaMainTab
implements ILaunchConfigurationTab {
    protected Text featurePathText;
    protected Text gluePathText;
    private WidgetListener listener = new WidgetListener();
    private Button featureButton;
    private Button glueButton;
    private Button monochromeCheckbox;
    private Button prettyCheckbox;
    private Button jsonCheckbox;
    private Button htmlCheckbox;
    private Button progressCheckbox;
    private Button usageCheckbox;
    private Button junitCheckbox;
    private Button rerunCheckbox;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        this.createProjectEditor(comp);
        this.setControl((Control)comp);
        this.createFeaturePathEditor(comp);
        this.createGluePathEditor(comp);
        this.createFormatterOptions(comp);
    }

    private void createFormatterOptions(Composite comp) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setText("Formatters:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.monochromeCheckbox = new Button((Composite)group, 32);
        this.monochromeCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.monochromeCheckbox.setText("monochrome");
        this.prettyCheckbox = new Button((Composite)group, 32);
        this.prettyCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.prettyCheckbox.setText("pretty");
        this.jsonCheckbox = new Button((Composite)group, 32);
        this.jsonCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.jsonCheckbox.setText("JSON");
        this.progressCheckbox = new Button((Composite)group, 32);
        this.progressCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.progressCheckbox.setText("progress");
        this.rerunCheckbox = new Button((Composite)group, 32);
        this.rerunCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.rerunCheckbox.setText("rerun");
        this.usageCheckbox = new Button((Composite)group, 32);
        this.usageCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.usageCheckbox.setText("usage");
        this.htmlCheckbox = new Button((Composite)group, 32);
        this.htmlCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.htmlCheckbox.setText("HTML");
        this.htmlCheckbox.setVisible(false);
        this.junitCheckbox = new Button((Composite)group, 32);
        this.junitCheckbox.addSelectionListener((SelectionListener)this.listener);
        this.junitCheckbox.setText("JUnit");
        this.junitCheckbox.setVisible(false);
    }

    private void createGluePathEditor(Composite comp) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setText("Glue:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.gluePathText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.gluePathText.setLayoutData((Object)gd);
        this.gluePathText.setFont(font);
        this.gluePathText.addModifyListener((ModifyListener)this.listener);
    }

    private void createFeaturePathEditor(Composite comp) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setText("Feature Path:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.featurePathText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.featurePathText.setLayoutData((Object)gd);
        this.featurePathText.setFont(font);
        this.featurePathText.addModifyListener((ModifyListener)this.listener);
        this.featureButton = this.createPushButton((Composite)group, LauncherMessages.AbstractJavaMainTab_1, null);
        this.featureButton.addSelectionListener((SelectionListener)this.listener);
    }

    public String getName() {
        return "Cucumber Feature Runner";
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute("cucumber feature", this.featurePathText.getText().trim());
        config.setAttribute("glue path", this.gluePathText.getText().trim());
        config.setAttribute("is monochrome?", this.monochromeCheckbox.getSelection());
        config.setAttribute("is json formatter?", this.jsonCheckbox.getSelection());
        config.setAttribute("is progress formatter?", this.progressCheckbox.getSelection());
        config.setAttribute("is pretty formatter?", this.prettyCheckbox.getSelection());
        config.setAttribute("is html formatter?", this.htmlCheckbox.getSelection());
        config.setAttribute("is usage formatter", this.usageCheckbox.getSelection());
        config.setAttribute("is junit formatter", this.junitCheckbox.getSelection());
        config.setAttribute("is rerun formatter", this.rerunCheckbox.getSelection());
        this.mapResources(config);
    }

    private String getDefaultGluePath() {
        return "classpath:";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IProject javaProject = CucumberFeatureLaunchUtils.getProject();
        String featurePath = CucumberFeatureLaunchUtils.getFeaturePath();
        String gluePath = this.getDefaultGluePath();
        if (javaProject != null && CucumberFeatureLaunchUtils.getFeaturePath() != null) {
            this.initializeCucumberProject(gluePath, featurePath, javaProject, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            config.setAttribute("cucumber feature", "");
            config.setAttribute("glue path", "");
            config.setAttribute("is monochrome?", true);
            config.setAttribute("is pretty formatter?", true);
            config.setAttribute("is progress formatter?", true);
            config.setAttribute("is html formatter?", true);
            config.setAttribute("is json formatter?", true);
            config.setAttribute("is usage formatter", true);
            config.setAttribute("is junit formatter", true);
            config.setAttribute("is rerun formatter", true);
        }
    }

    protected void handleSearchButtonSelected() {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateFeaturePathFromConfig(config);
        this.updateGluePathFromConfig(config);
        this.updateFormattersFromConfig(config);
    }

    private void updateFormattersFromConfig(ILaunchConfiguration config) {
        this.monochromeCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is monochrome?"));
        this.jsonCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is json formatter?"));
        this.junitCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is junit formatter"));
        this.prettyCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is pretty formatter?"));
        this.progressCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is progress formatter?"));
        this.htmlCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is html formatter?"));
        this.usageCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is usage formatter"));
        this.rerunCheckbox.setSelection(CucumberFeatureLaunchUtils.updateFromConfig(config, "is rerun formatter"));
    }

    private void updateGluePathFromConfig(ILaunchConfiguration config) {
        CucumberFeatureLaunchUtils.updateFromConfig(config, "glue path", this.gluePathText);
    }

    private void updateFeaturePathFromConfig(ILaunchConfiguration config) {
        CucumberFeatureLaunchUtils.updateFromConfig(config, "cucumber feature", this.featurePathText);
    }

    protected void initializeCucumberProject(String gluePath, String featurePath, IProject javaProject, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getName();
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
        config.setAttribute("cucumber feature", featurePath);
        config.setAttribute("glue path", gluePath);
        config.setAttribute("is monochrome?", true);
        config.setAttribute("is pretty formatter?", true);
        config.setAttribute("is html formatter?", false);
        config.setAttribute("is usage formatter", false);
        config.setAttribute("is progress formatter?", false);
        config.setAttribute("is rerun formatter", false);
        config.setAttribute("is json formatter?", false);
        config.setAttribute("is junit formatter", false);
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            CucumberMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == CucumberMainTab.this.featureButton) {
                FileDialog fileDialog = new FileDialog(CucumberMainTab.this.getShell());
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{"*.feature"});
                fileDialog.setFilterNames(new String[]{"Features(*.feature)"});
                fileDialog.setFileName(CucumberMainTab.this.featurePathText.getText());
                CucumberMainTab.this.featurePathText.setText(fileDialog.open());
            } else if (source != CucumberMainTab.this.glueButton) {
                CucumberMainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

