/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ProxyHelper {
    private static final Pattern HTTP_PROXY_STATUS_LINE_PATTERN = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private static final int SOCKS_COMMAND_CONNECT = 1;
    private static final int SOCKS_VERSION4 = 4;
    private static final int SOCKS_VERSION5 = 5;
    private static final int SOCKS_RESPONSE_REQUEST_OK = 0;
    private static final int SOCKS_AUTH_TYPE_NO_AUTHENTICATION = 0;
    private static final int SOCKS_AUTH_TYPE_USER_PASSWORD = 2;
    private static final int SOCKS_AUTH_TYPE_UNKNOWN = -1;
    private static final int SOCKS_ADDRESS_TYPE_IPV4 = 1;
    private static final int SOCKS_ADDRESS_TYPE_DOMAIN_NAME = 3;
    private static final int SOCKS_ADDRESS_TYPE_IPV6 = 4;

    ProxyHelper() {
    }

    static void connectViaProxy(Proxy proxy, InetSocketAddress inetSocketAddress, SocketChannel socketChannel) throws IOException {
        if (proxy.type() == Proxy.Type.HTTP) {
            ProxyHelper.doHTTPTunneling(inetSocketAddress, socketChannel);
        } else if (proxy.type() == Proxy.Type.SOCKS) {
            ProxyHelper.doSOCKSTunneling(inetSocketAddress, socketChannel, proxy);
        } else {
            throw new IOException("Unknown proxy type : " + proxy.type());
        }
    }

    private static void doHTTPTunneling(InetSocketAddress inetSocketAddress, SocketChannel socketChannel) throws IOException {
        String string = inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONNECT " + string + " HTTP/1.0\r\n");
        stringBuilder.append("Host: " + string + "\r\n");
        stringBuilder.append("\r\n");
        ByteBuffer byteBuffer = ByteBuffer.wrap(stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1));
        while (byteBuffer.hasRemaining()) {
            socketChannel.write(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
        socketChannel.read(byteBuffer2);
        byteBuffer2.flip();
        String string2 = new String(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit(), StandardCharsets.US_ASCII);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        String string3 = bufferedReader.readLine();
        Matcher matcher = HTTP_PROXY_STATUS_LINE_PATTERN.matcher(string3);
        if (!matcher.matches()) {
            throw new IOException("HTTP proxy tunneling failed [" + string3 + "]");
        }
        int n2 = Integer.parseInt(matcher.group(1));
        String string4 = matcher.group(2);
        if (n2 != 200) {
            throw new IOException("HTTP proxy tunneling failed [" + n2 + ":" + string3 + "]");
        }
    }

    private static void doSOCKSTunneling(InetSocketAddress inetSocketAddress, SocketChannel socketChannel, Proxy proxy) throws IOException {
        ProxyHelper.checkEndPointAccessPermission(inetSocketAddress);
        ByteBuffer byteBuffer = ByteBuffer.allocate(512);
        ProxyHelper.doSOCKSAuthentication(inetSocketAddress, socketChannel, proxy, byteBuffer);
        ProxyHelper.doSOCKSConnect(inetSocketAddress, socketChannel, proxy, byteBuffer);
    }

    private static void doSOCKSAuthentication(InetSocketAddress inetSocketAddress, SocketChannel socketChannel, Proxy proxy, ByteBuffer byteBuffer) throws IOException {
        ProxyHelper.writeAuthPacket(byteBuffer, socketChannel);
        int n2 = ProxyHelper.read(byteBuffer, socketChannel, 2);
        if (n2 == 2 && byteBuffer.get(0) == 5) {
            byte by = byteBuffer.get(1);
            if (by == -1) {
                throw new SocketException("Unknown SOCKS Authentication.");
            }
            if (!ProxyHelper.authenticate(by, byteBuffer, socketChannel, proxy)) {
                throw new SocketException("SOCKS Authentication failure.");
            }
        } else {
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.toString());
            }
            ProxyHelper.doSOCKSV4Connect(byteBuffer, socketChannel, inetSocketAddress);
            return;
        }
    }

    private static void doSOCKSConnect(InetSocketAddress inetSocketAddress, SocketChannel socketChannel, Proxy proxy, ByteBuffer byteBuffer) throws IOException {
        ProxyHelper.writeConnectPacket(byteBuffer, socketChannel, inetSocketAddress);
        int n2 = ProxyHelper.read(byteBuffer, socketChannel, 4);
        if (n2 != 4) {
            throw new SocketException("SOCKS Bad response.");
        }
        if (byteBuffer.get(1) != 0) {
            throw new SocketException("SOCKS Connect Failure : " + byteBuffer.get(1));
        }
        ProxyHelper.processConnectSuccess(byteBuffer, socketChannel);
    }

    private static void checkEndPointAccessPermission(InetSocketAddress inetSocketAddress) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            } else {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
        }
    }

    private static void processConnectSuccess(ByteBuffer byteBuffer, SocketChannel socketChannel) throws IOException {
        SocketException socketException = null;
        byte by = byteBuffer.get(3);
        switch (by) {
            case 1: {
                byte[] byArray = new byte[4];
                int n2 = ProxyHelper.read(byteBuffer, socketChannel, 4);
                if (n2 != 4) {
                    throw new SocketException("SOCKS Bad response.");
                }
                byteBuffer.get(byArray);
                n2 = ProxyHelper.read(byteBuffer, socketChannel, 2);
                if (n2 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 3: {
                byte by2 = byteBuffer.get(1);
                byte[] byArray = new byte[by2];
                int n3 = ProxyHelper.read(byteBuffer, socketChannel, by2);
                if (n3 != by2) {
                    throw new SocketException("SOCKS Bad response.");
                }
                byteBuffer.get(byArray);
                n3 = ProxyHelper.read(byteBuffer, socketChannel, 2);
                if (n3 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 4: {
                byte by3 = byteBuffer.get(1);
                byte[] byArray = new byte[by3];
                int n4 = ProxyHelper.read(byteBuffer, socketChannel, by3);
                if (n4 != by3) {
                    throw new SocketException("SOCKS Bad response.");
                }
                byteBuffer.get(byArray);
                n4 = ProxyHelper.read(byteBuffer, socketChannel, 2);
                if (n4 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            default: {
                socketException = new SocketException("SOCKS Bad response.");
            }
        }
    }

    private static void writeAuthPacket(ByteBuffer byteBuffer, SocketChannel socketChannel) throws IOException {
        byteBuffer.clear();
        byteBuffer.put((byte)5);
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)2);
        byteBuffer.flip();
        socketChannel.write(byteBuffer);
    }

    private static void writeConnectPacket(ByteBuffer byteBuffer, SocketChannel socketChannel, InetSocketAddress inetSocketAddress) throws IOException {
        byteBuffer.clear();
        byteBuffer.put((byte)5);
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)0);
        if (inetSocketAddress.isUnresolved()) {
            byteBuffer.put((byte)3);
            byteBuffer.put((byte)inetSocketAddress.getHostName().length());
            byteBuffer.put(inetSocketAddress.getHostName().getBytes("ISO-8859-1"));
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 8 & 0xFF));
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 0 & 0xFF));
        } else if (inetSocketAddress.getAddress() instanceof Inet6Address) {
            byteBuffer.put((byte)4);
            byteBuffer.put(inetSocketAddress.getAddress().getAddress());
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 8 & 0xFF));
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 0 & 0xFF));
        } else {
            byteBuffer.put((byte)1);
            byteBuffer.put(inetSocketAddress.getAddress().getAddress());
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 8 & 0xFF));
            byteBuffer.put((byte)(inetSocketAddress.getPort() >> 0 & 0xFF));
        }
        byteBuffer.flip();
        socketChannel.write(byteBuffer);
    }

    private static int read(ByteBuffer byteBuffer, SocketChannel socketChannel, int n2) throws IOException {
        byteBuffer.clear().limit(n2);
        for (int i2 = 0; byteBuffer.hasRemaining() && i2 < 3; ++i2) {
            socketChannel.read(byteBuffer);
            if (!byteBuffer.hasRemaining()) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        byteBuffer.flip();
        return byteBuffer.remaining();
    }

    private static boolean authenticate(int n2, ByteBuffer byteBuffer, SocketChannel socketChannel, Proxy proxy) throws IOException {
        if (n2 == 0) {
            return true;
        }
        if (n2 == 2) {
            String string;
            InetAddress inetAddress;
            int n3;
            String string2 = null;
            String string3 = ((InetSocketAddress)proxy.address()).getHostString();
            PasswordAuthentication passwordAuthentication = ProxyHelper.getUserPassword(string3, n3 = ((InetSocketAddress)proxy.address()).getPort(), inetAddress = InetAddress.getByName(string3));
            if (passwordAuthentication != null) {
                string = passwordAuthentication.getUserName();
                string2 = new String(passwordAuthentication.getPassword());
            } else {
                string = System.getProperty("user.name", "");
            }
            if (string == null) {
                return false;
            }
            byteBuffer.clear();
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)string.length());
            byteBuffer.put(string.getBytes("ISO-8859-1"));
            if (string2 != null) {
                byteBuffer.put((byte)string2.length());
                byteBuffer.put(string2.getBytes("ISO-8859-1"));
            } else {
                byteBuffer.put((byte)0);
            }
            byteBuffer.flip();
            socketChannel.write(byteBuffer);
            int n4 = ProxyHelper.read(byteBuffer, socketChannel, 2);
            return n4 == 2 && byteBuffer.get(1) == 0;
        }
        return false;
    }

    private static PasswordAuthentication getUserPassword(final String string, final int n2, final InetAddress inetAddress) {
        return AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

            @Override
            public PasswordAuthentication run() {
                return Authenticator.requestPasswordAuthentication(string, inetAddress, n2, "SOCKS5", "SOCKS authentication", null);
            }
        });
    }

    private static void doSOCKSV4Connect(ByteBuffer byteBuffer, SocketChannel socketChannel, InetSocketAddress inetSocketAddress) throws IOException {
        if (!(inetSocketAddress.getAddress() instanceof Inet4Address)) {
            throw new SocketException("SOCKS V4 requires IPv4 only addresses");
        }
        byteBuffer.clear();
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)(inetSocketAddress.getPort() >> 8 & 0xFF));
        byteBuffer.put((byte)(inetSocketAddress.getPort() >> 0 & 0xFF));
        byteBuffer.put(inetSocketAddress.getAddress().getAddress());
        String string = System.getProperty("user.name", "");
        byteBuffer.put(string.getBytes("ISO-8859-1"));
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        socketChannel.write(byteBuffer);
        int n2 = ProxyHelper.read(byteBuffer, socketChannel, 8);
        if (n2 != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n2);
        }
        if (byteBuffer.get(0) != 0 && byteBuffer.get(0) != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        switch (byteBuffer.get(1)) {
            case 91: {
                throw new SocketException("SOCKS Failure: request rejected.");
            }
            case 92: {
                throw new SocketException("SOCKS Failure: unable to connect to destination.");
            }
            case 93: {
                throw new SocketException("SOCKS Failure: authentication failed.");
            }
        }
        throw new SocketException("SOCKS Failure: bad status : " + byteBuffer.get(1));
    }
}

