/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner;

import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.AbstractRefactoringCodeVisitor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ClassImport;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.StaticClassImport;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.StaticFieldImport;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public abstract class RefactoringCodeVisitorSupport
extends AbstractRefactoringCodeVisitor {
    protected ModuleNode rootNode;

    public RefactoringCodeVisitorSupport(ModuleNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public void visitClassImport(ClassImport classImport) {
    }

    protected void analyzeNode(ASTNode node) {
    }

    protected void clear(ASTNode node) {
    }

    @Override
    public void visitStaticClassImport(StaticClassImport staticClassImport) {
    }

    @Override
    public void visitStaticFieldImport(StaticFieldImport staticAliasImport) {
    }

    @Override
    public void scanAST() {
        this.analyseClassImports();
        this.analyseStaticClassImport();
        this.analyseStaticFieldImport();
        if (!this.rootNode.getStatementBlock().isEmpty()) {
            for (Statement statement : this.rootNode.getStatementBlock().getStatements()) {
                statement.visit((GroovyCodeVisitor)this);
            }
        }
        List classes = this.rootNode.getClasses();
        for (ClassNode classNode : classes) {
            if (!GroovyUtils.isScript((ClassNode)classNode)) {
                this.visitClass(classNode);
                continue;
            }
            List methods = this.rootNode.getMethods();
            for (MethodNode method : methods) {
                this.visitMethod(method);
            }
        }
    }

    private void analyseStaticFieldImport() {
        for (Map.Entry aliasOrField : this.rootNode.getStaticImports().entrySet()) {
            StaticFieldImport staticAliasImport = new StaticFieldImport(((ImportNode)aliasOrField.getValue()).getType(), (String)aliasOrField.getKey(), ((ImportNode)aliasOrField.getValue()).getFieldName());
            staticAliasImport.setSourcePosition((ASTNode)aliasOrField.getValue());
            this.visitStaticFieldImport(staticAliasImport);
        }
    }

    private void analyseStaticClassImport() {
        for (ImportNode staticImp : this.rootNode.getStaticImports().values()) {
            ClassNode type = staticImp.getType();
            StaticClassImport staticClassImport = new StaticClassImport(type);
            staticClassImport.setSourcePosition((ASTNode)type);
            this.visitStaticClassImport(staticClassImport);
        }
    }

    private void analyseClassImports() {
        List imports = this.rootNode.getImports();
        for (ImportNode importNode : imports) {
            ClassImport classImport = new ClassImport(importNode);
            classImport.setSourcePosition((ASTNode)importNode.getType());
            this.visitClassImport(classImport);
        }
    }

    protected void analyzeNodes(ASTNode[] nodes) {
        if (nodes != null) {
            ASTNode[] aSTNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode node = aSTNodeArray[n2];
                this.analyzeNode(node);
                this.clear(node);
                ++n2;
            }
        }
    }

    protected void analyzeTypes(ClassNode[] types) {
        if (types != null) {
            ClassNode[] classNodeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode type = classNodeArray[n2];
                if (type != null) {
                    this.analyzeType(type);
                    this.clear((ASTNode)type);
                }
                ++n2;
            }
        }
    }

    @Override
    public void analyzeType(ClassNode node) {
        this.analyzeTypeInternal(node);
    }

    private void analyzeTypeInternal(ClassNode type) {
        type = GroovyUtils.getBaseType((ClassNode)type);
        this.analyzeNode((ASTNode)type);
        this.analyzeGenerics(type);
    }

    @Override
    public void analyzeParameter(Parameter parameter) {
        this.analyzeNode((ASTNode)parameter);
    }

    protected void analyzeGenerics(ClassNode node) {
        if (node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (!node.getName().equals(genericsType.getType().getName())) {
                    this.analyzeType(genericsType.getType());
                    this.clear((ASTNode)genericsType.getType());
                    if (genericsType.getLowerBound() != null) {
                        this.analyzeType(genericsType.getLowerBound());
                        this.clear((ASTNode)genericsType.getLowerBound());
                    }
                    if (genericsType.getUpperBounds() != null) {
                        ClassNode[] upperBounds = (ClassNode[])genericsType.getUpperBounds().clone();
                        int i = 0;
                        int n3 = upperBounds.length;
                        while (i < n3) {
                            if (upperBounds[i].getName().equals(node.getName())) {
                                upperBounds[i] = null;
                            }
                            ++i;
                        }
                        this.analyzeTypes(upperBounds);
                    }
                }
                ++n2;
            }
        }
    }

    protected void analyseParameters(Parameter[] parameters) {
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                this.analyzeParameter(parameter);
                this.analyzeType(parameter.getOriginType());
                this.clear((ASTNode)parameter.getOriginType());
                if (parameter.hasInitialExpression()) {
                    parameter.getInitialExpression().visit((GroovyCodeVisitor)this);
                }
                this.clear((ASTNode)parameter);
                ++n2;
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        List annotionMap = node.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotionMap) {
            if (an.isBuiltIn()) continue;
            for (Map.Entry entry : an.getMembers().entrySet()) {
                ((Expression)entry.getValue()).visit((GroovyCodeVisitor)this);
            }
        }
    }

    public void visitClass(ClassNode node) {
        this.analyzeTypeInternal(node);
        this.analyzeType(node.getUnresolvedSuperClass());
        this.clear((ASTNode)node.getUnresolvedSuperClass());
        this.analyzeTypes(node.getInterfaces());
        node.visitContents((GroovyClassVisitor)this);
        this.clear((ASTNode)node);
    }

    public void visitField(FieldNode node) {
        this.analyzeNode((ASTNode)node);
        this.analyzeType(node.getOriginType());
        this.clear((ASTNode)node.getOriginType());
        Expression initExp = node.getInitialValueExpression();
        if (initExp != null) {
            this.analyzeNode((ASTNode)initExp);
            initExp.visit((GroovyCodeVisitor)this);
            this.clear((ASTNode)initExp);
        }
        this.clear((ASTNode)node);
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit((GroovyCodeVisitor)this);
        }
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations((AnnotatedNode)node);
        this.analyseMethodHead(node);
        Statement code = node.getCode();
        this.visitClassCodeContainer(code);
    }

    public void visitConstructor(ConstructorNode node) {
        this.analyzeNode((ASTNode)node);
        this.visitConstructorOrMethod((MethodNode)node, true);
        this.clear((ASTNode)node);
    }

    public void visitMethod(MethodNode node) {
        this.analyzeNode((ASTNode)node);
        this.visitConstructorOrMethod(node, false);
        this.clear((ASTNode)node);
    }

    private void analyseMethodHead(MethodNode node) {
        this.analyzeType(node.getReturnType());
        this.clear((ASTNode)node.getReturnType());
        this.analyseParameters(node.getParameters());
        this.analyzeTypes(node.getExceptions());
    }

    public void visitProperty(PropertyNode node) {
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.analyzeNode((ASTNode)expression);
        this.analyzeType(expression.getOriginType());
        this.clear((ASTNode)expression.getOriginType());
        super.visitVariableExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.analyzeNode((ASTNode)expression);
        this.analyseParameters(expression.getParameters());
        super.visitClosureExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        ClassNode baseType = GroovyUtils.getBaseType((ClassNode)expression.getType());
        this.analyzeNode((ASTNode)expression);
        this.analyzeType(baseType);
        this.clear((ASTNode)baseType);
        super.visitArrayExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitAssertStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitAttributeExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitBinaryExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitBitwiseNegationExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitBlockStatement(BlockStatement block) {
        this.analyzeNode((ASTNode)block);
        super.visitBlockStatement(block);
        this.clear((ASTNode)block);
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitBooleanExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitBreakStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitCaseStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitCastExpression(CastExpression expression) {
        this.analyzeNode((ASTNode)expression);
        this.analyzeType(expression.getType());
        this.clear((ASTNode)expression.getType());
        super.visitCastExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.analyzeNode((ASTNode)statement);
        this.analyzeType(statement.getExceptionType());
        this.clear((ASTNode)statement.getExceptionType());
        super.visitCatchStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitClassExpression(ClassExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitClassExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitClosureListExpression(ClosureListExpression cle) {
        this.analyzeNode((ASTNode)cle);
        super.visitClosureListExpression(cle);
        this.clear((ASTNode)cle);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitConstantExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.analyzeNode((ASTNode)call);
        this.analyzeType(call.getType());
        this.clear((ASTNode)call.getType());
        super.visitConstructorCallExpression(call);
        this.clear((ASTNode)call);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitContinueStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.analyzeNode((ASTNode)loop);
        super.visitDoWhileLoop(loop);
        this.clear((ASTNode)loop);
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitExpressionStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (!expression.getType().getNameWithoutPackage().equals("MetaClass")) {
            this.analyzeNode((ASTNode)expression);
            super.visitFieldExpression(expression);
            this.clear((ASTNode)expression);
        }
    }

    public void visitForLoop(ForStatement forLoop) {
        this.analyzeNode((ASTNode)forLoop);
        super.visitForLoop(forLoop);
        this.clear((ASTNode)forLoop);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitGStringExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitIfElse(IfStatement ifElse) {
        this.analyzeNode((ASTNode)ifElse);
        super.visitIfElse(ifElse);
        this.clear((ASTNode)ifElse);
    }

    public void visitListExpression(ListExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitListExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitMapEntryExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitMapExpression(MapExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitMapExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.analyzeNode((ASTNode)call);
        super.visitMethodCallExpression(call);
        this.clear((ASTNode)call);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitMethodPointerExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitNotExpression(NotExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitNotExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitPostfixExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitPrefixExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitPropertyExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitRangeExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitReturnStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitShortTernaryExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitSpreadExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitSpreadMapExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.analyzeNode((ASTNode)call);
        super.visitStaticMethodCallExpression(call);
        this.clear((ASTNode)call);
    }

    public void visitSwitch(SwitchStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitSwitch(statement);
        this.clear((ASTNode)statement);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitSynchronizedStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitTernaryExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitThrowStatement(statement);
        this.clear((ASTNode)statement);
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.analyzeNode((ASTNode)statement);
        super.visitTryCatchFinally(statement);
        this.clear((ASTNode)statement);
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitTupleExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitUnaryMinusExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.analyzeNode((ASTNode)expression);
        super.visitUnaryPlusExpression(expression);
        this.clear((ASTNode)expression);
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.analyzeNode((ASTNode)loop);
        super.visitWhileLoop(loop);
        this.clear((ASTNode)loop);
    }
}

