/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStreamException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.antlr.GroovySourceToken;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.core.util.GroovyScanner;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;

public class GroovyDocumentScanner
implements IDocumentListener {
    private static final boolean TOKEN_POSITION_ASSERTS = true;
    private IDocument document;
    protected List<Token> tokens;
    private GroovyScanner tokenScanner;
    private static int logLimit = 4;
    private static final int NOT_FOUND = -1;

    public GroovyDocumentScanner(IDocument document) {
        this.document = document;
        this.document.addDocumentListener((IDocumentListener)this);
        this.reset();
    }

    public void documentChanged(DocumentEvent event) {
        this.reset();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    protected void ensureScanned(int end) {
        if (this.tokens == null) {
            this.tokenScanner = new GroovyScanner(this.document.get());
            this.tokens = this.getTokensIncludingEOF();
        }
    }

    private List<Token> getTokensIncludingEOF() {
        ArrayList<Token> result;
        block4: {
            result = new ArrayList<Token>(256);
            try {
                Token token;
                do {
                    token = this.nextToken();
                    result.add(token);
                } while (token.getType() != GroovyTokenTypeBridge.EOF);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (Exception e) {
                if (logLimit-- <= 0) break block4;
                Util.log((Throwable)e);
            }
        }
        return result;
    }

    private Token nextToken() throws TokenStreamException, BadLocationException {
        Token token;
        try {
            token = this.tokenScanner.nextToken();
        }
        catch (TokenStreamException e) {
            this.tokenScanner.recover(this.document);
            token = this.tokenScanner.nextToken();
        }
        return token;
    }

    private void reset() {
        this.tokens = null;
    }

    public int getOffset(Token token) throws BadLocationException {
        int offset = 0;
        if (token != null) {
            offset = GroovyScanner.getOffset((IDocument)this.document, (int)token.getLine(), (int)token.getColumn());
            if (token.getType() != GroovyTokenTypeBridge.EOF) {
                int col = token.getColumn() - 1;
                int line = token.getLine() - 1;
                Assert.isTrue((col >= 0 ? 1 : 0) != 0);
                Assert.isTrue((col < this.document.getLineLength(line) ? 1 : 0) != 0, (String)("Token: " + String.valueOf(token)));
                Assert.isTrue((offset < this.document.getLength() ? 1 : 0) != 0);
                if (token.getType() == GroovyTokenTypeBridge.IDENT) {
                    String antlrText = token.getText();
                    String eclipseText = this.document.get(offset, antlrText.length());
                    Assert.isTrue((boolean)eclipseText.equals(antlrText));
                }
            }
        }
        return offset;
    }

    public int getEnd(Token token) throws BadLocationException {
        GroovySourceToken gToken = (GroovySourceToken)token;
        return GroovyScanner.getOffset((IDocument)this.document, (int)gToken.getLineLast(), (int)gToken.getColumnLast());
    }

    public void dispose() {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
            this.document = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public IDocument getDocument() {
        return this.document;
    }

    public List<Token> getTokens(ITextSelection selection) {
        int end;
        int start;
        if (selection == null || selection.getLength() == 0) {
            start = 0;
            end = this.document.getLength();
        } else {
            start = selection.getOffset();
            end = start + selection.getLength();
        }
        return this.getTokens(start, end);
    }

    public List<Token> getTokens(int start, int end) {
        if (start >= end) {
            return new ArrayList<Token>();
        }
        try {
            int startTokenIndex = this.findTokenFrom(start);
            if (startTokenIndex == -1) {
                return new ArrayList<Token>();
            }
            if (this.getOffset(this.tokens.get(startTokenIndex)) >= end) {
                return new ArrayList<Token>();
            }
            int endTokenIndex = this.findTokenFrom(end);
            endTokenIndex = endTokenIndex == -1 ? this.tokens.size() - 1 : --endTokenIndex;
            Assert.isTrue((startTokenIndex <= endTokenIndex ? 1 : 0) != 0);
            return this.tokens.subList(startTokenIndex, endTokenIndex + 1);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
    }

    public List<Token> getLineTokensUpto(int offset) {
        try {
            int start = this.document.getLineOffset(this.document.getLineOfOffset(offset));
            return this.getTokens(start, offset);
        }
        catch (BadLocationException e) {
            return new ArrayList<Token>();
        }
    }

    public List<Token> getLineTokensFrom(int offset) {
        try {
            int line = this.document.getLineOfOffset(offset);
            int lineEnd = this.document.getLineOffset(line) + this.document.getLineLength(line);
            return this.getTokens(offset, lineEnd);
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Recoverable internal error", (Throwable)e);
            return new ArrayList<Token>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int findTokenFrom(int offset) {
        Assert.isLegal((offset >= 0 ? 1 : 0) != 0);
        this.ensureScanned(offset);
        try {
            int start = 0;
            int end = this.tokens.size() - 1;
            while (true) {
                if (start > end) {
                    return -1;
                }
                if (this.getOffset(this.tokens.get(start)) >= offset) {
                    return start;
                }
                if (++start > end) {
                    return -1;
                }
                int mid = (start + end) / 2;
                int midOfs = this.getOffset(this.tokens.get(mid));
                if (midOfs >= offset) {
                    end = mid;
                    continue;
                }
                start = mid + 1;
            }
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
    }

    public Token getLastTokenBefore(int offset) {
        int index = this.findTokenFrom(offset);
        if (index == -1) {
            return this.getLastToken();
        }
        if (index > 0) {
            return this.tokens.get(index - 1);
        }
        return null;
    }

    public Token getLastTokenBefore(Token token) throws BadLocationException {
        return this.getLastTokenBefore(this.getOffset(token));
    }

    public Token getLastToken() {
        this.ensureScanned(Integer.MAX_VALUE);
        return this.tokens.get(this.tokens.size() - 1);
    }

    public List<Token> getLineTokens(int line) throws BadLocationException {
        int lineOffset = this.document.getLineOffset(line);
        return this.getTokens(lineOffset, lineOffset + this.document.getLineLength(line));
    }

    public Token getTokenFrom(int offset) {
        int index = this.findTokenFrom(offset);
        if (index == -1) {
            return null;
        }
        return this.tokens.get(index);
    }

    public Token getNextToken(Token token) throws BadLocationException {
        return this.getTokenFrom(this.getOffset(token) + 1);
    }

    public Token getLastNonWhitespaceTokenBefore(int offset) throws BadLocationException {
        Token result = this.getLastTokenBefore(offset);
        while (result != null && this.isWhitespace(result)) {
            result = this.getLastTokenBefore(result);
        }
        return result;
    }

    private boolean isWhitespace(Token result) {
        int type = result.getType();
        return type == GroovyTokenTypeBridge.WS || type == GroovyTokenTypeBridge.NLS;
    }
}

