/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.Map;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import org.littleshoot.proxy.impl.ProxyUtils;

public class AutoBasicAuthFilter
extends HttpsAwareFiltersAdapter {
    private final Map<String, String> credentialsByHostname;

    public AutoBasicAuthFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Map<String, String> credentialsByHostname) {
        super(originalRequest, ctx);
        this.credentialsByHostname = credentialsByHostname;
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (this.credentialsByHostname.isEmpty()) {
            return null;
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
                return null;
            }
            String hostname = this.getHost(httpRequest);
            String base64CredentialsForHostname = this.credentialsByHostname.get(hostname);
            if (base64CredentialsForHostname != null) {
                httpRequest.headers().add("Authorization", (Object)("Basic " + base64CredentialsForHostname));
            }
        }
        return null;
    }
}

