/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper;

import com.kms.katalon.core.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static Document readXML(String rawInput) {
        Document doc;
        ByteArrayInputStream input;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        StringBuilder xmlStringBuilder = new StringBuilder();
        xmlStringBuilder.append(rawInput);
        try {
            input = new ByteArrayInputStream(xmlStringBuilder.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        try {
            doc = builder.parse(input);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
        return doc;
    }

    public static String docToString(Document doc) {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (TransformerException transformerException) {
            return null;
        }
        String xmlString = writer.getBuffer().toString();
        return xmlString;
    }

    public static Node findNodeByAttributes(Document doc, String ... attributes) {
        Map<String, String> attrs = ArrayUtil.toMap(attributes);
        return XMLHelper.findNodeByAttributes(XMLHelper.getNodeList(doc), attrs);
    }

    public static Node findNodeByAttributes(Node root, String ... attributes) {
        Map<String, String> attrs = ArrayUtil.toMap(attributes);
        return XMLHelper.findNodeByAttributes(root, attrs);
    }

    public static Node findNodeByAttributes(Node root, Map<String, String> attributes) {
        return XMLHelper.findNodeByAttributes(XMLHelper.getNodeList(root), attributes);
    }

    public static Node findNodeByAttributes(NodeList nodes, Map<String, String> attributes) {
        List<Node> foundNodes = XMLHelper.findNodesByAttributes(nodes, attributes);
        return ArrayUtil.getFirst(foundNodes);
    }

    public static List<Node> findNodesByAttributes(NodeList nodes, String ... attributes) {
        Map<String, String> attrs = ArrayUtil.toMap(attributes);
        return XMLHelper.findNodesByAttributes(nodes, attrs);
    }

    public static List<Node> findNodesByAttributes(NodeList nodes, Map<String, String> attributes) {
        return XMLHelper.findNodes(nodes, (Node node) -> attributes.entrySet().stream().allMatch(entry -> {
            Node attrNode = node.getAttributes().getNamedItem((String)entry.getKey());
            if (attrNode == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)attrNode.getNodeValue(), (CharSequence)((CharSequence)entry.getValue()));
        }));
    }

    public static Node findNodeByTagName(Document doc, String tagName) {
        return XMLHelper.findNodeByTagName(XMLHelper.getNodeList(doc), tagName);
    }

    public static Node findNodeByTagName(Node root, String tagName) {
        return XMLHelper.findNodeByTagName(XMLHelper.getNodeList(root), tagName);
    }

    public static Node findNodeByTagName(NodeList nodes, String tagName) {
        return XMLHelper.findNode(nodes, (Node node) -> StringUtils.equals((CharSequence)node.getNodeName(), (CharSequence)tagName));
    }

    public static List<Node> findNodesByTagName(Node root, String tagName) {
        return XMLHelper.findNodesByTagName(XMLHelper.getNodeList(root), tagName);
    }

    public static List<Node> findNodesByTagName(NodeList nodes, String tagName) {
        return XMLHelper.findNodes(nodes, (Node node) -> StringUtils.equals((CharSequence)node.getNodeName(), (CharSequence)tagName));
    }

    public static Node findNode(Document doc, NodeFinder filter) {
        return XMLHelper.findNode(XMLHelper.getNodeList(doc), filter);
    }

    public static Node findNode(Node root, NodeFinder filter) {
        return XMLHelper.findNode(XMLHelper.getNodeList(root), filter);
    }

    public static Node findNode(NodeList nodes, NodeFinder filter) {
        List<Node> foundNodes = XMLHelper.findNodes(nodes, filter, true);
        return ArrayUtil.getFirst(foundNodes);
    }

    public static List<Node> findNodes(Document doc, NodeFinder filter) {
        return XMLHelper.findNodes(XMLHelper.getNodeList(doc), filter);
    }

    public static List<Node> findNodes(Node root, NodeFinder filter) {
        return XMLHelper.findNodes(XMLHelper.getNodeList(root), filter);
    }

    public static List<Node> findNodes(NodeList nodes, NodeFinder filter) {
        return XMLHelper.findNodes(nodes, filter, false);
    }

    public static List<Node> findNodes(NodeList nodes, NodeFinder filter, boolean returnFirstMatch) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Node> foundNodes = new ArrayList<Node>();
        int numChildren = nodes.getLength();
        int i = 0;
        while (i < numChildren) {
            Node nodeI = nodes.item(i);
            if (nodeI.getAttributes() != null) {
                boolean isMatched;
                boolean bl = isMatched = filter == null || filter.test(nodeI);
                if (isMatched) {
                    foundNodes.add(nodeI);
                    if (returnFirstMatch) break;
                }
            }
            ++i;
        }
        return foundNodes;
    }

    public static Element createElement(Document doc, String tagName, String ... attributes) {
        Map<String, String> attrs = ArrayUtil.toMap(attributes);
        return XMLHelper.createElement(doc, tagName, attrs);
    }

    public static Element createElement(Document doc, String tagName, Map<String, String> attributes) {
        Element element = doc.createElement(tagName);
        attributes.entrySet().stream().forEachOrdered(attribute -> element.setAttribute((String)attribute.getKey(), (String)attribute.getValue()));
        return element;
    }

    public static NodeList getNodeList(Document doc) {
        Element root = doc != null ? doc.getDocumentElement() : null;
        return XMLHelper.getNodeList(root);
    }

    public static NodeList getNodeList(Node root) {
        return root != null ? root.getChildNodes() : null;
    }

    public static Map<String, String> getNodeAttributes(Node node) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NamedNodeMap nodeAttrs = node.getAttributes();
        if (nodeAttrs != null && nodeAttrs.getLength() > 0) {
            int i = 0;
            while (i < nodeAttrs.getLength()) {
                Node attrI = nodeAttrs.item(i);
                attrs.put(attrI.getNodeName(), attrI.getNodeValue());
                ++i;
            }
        }
        return attrs;
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        if (node == null || StringUtils.isBlank((CharSequence)attributeName)) {
            return null;
        }
        NamedNodeMap nodeAttrs = node.getAttributes();
        if (nodeAttrs != null && nodeAttrs.getLength() > 0) {
            int i = 0;
            while (i < nodeAttrs.getLength()) {
                Node attrI = nodeAttrs.item(i);
                if (StringUtils.equals((CharSequence)attrI.getNodeName(), (CharSequence)attributeName)) {
                    return attrI.getNodeValue();
                }
                ++i;
            }
        }
        return null;
    }

    public static interface NodeFinder {
        public boolean test(Node var1);
    }
}

