/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenrecorder;

import com.kms.katalon.core.helper.screenrecorder.ATUVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.AbstractVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.CDTVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.IVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.Recorder;
import com.kms.katalon.core.helper.screenrecorder.VideoConfiguration;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;

public class VideoRecorder
implements IVideoRecorder {
    private AbstractVideoRecorder delegate;
    private String outputDirLocation;
    private String outputVideoName;

    public VideoRecorder(String outputDirLocation, String outputVideoName, VideoConfiguration videoConfig) throws VideoRecorderException {
        this.outputDirLocation = outputDirLocation;
        this.outputVideoName = outputVideoName;
        this.initRecorder(videoConfig);
    }

    public VideoRecorder(String outputDirLocation, String outputVideoName) throws VideoRecorderException {
        this.outputDirLocation = outputDirLocation;
        this.outputVideoName = outputVideoName;
        this.initRecorder(new VideoConfiguration());
    }

    public void setOutputDirLocation(String outputDirLocation) throws VideoRecorderException {
        this.outputDirLocation = outputDirLocation;
        this.reload();
    }

    public void setOutputVideoName(String outputVideoName) throws VideoRecorderException {
        this.outputVideoName = outputVideoName;
        this.reload();
    }

    private void initRecorder(VideoConfiguration videoConfig) throws VideoRecorderException {
        Recorder recorderConfig = videoConfig.getRecorder();
        if (Recorder.ATU == recorderConfig) {
            this.delegate = new ATUVideoRecorder(this.outputDirLocation, this.outputVideoName, videoConfig);
        } else if (Recorder.CDT == recorderConfig) {
            this.delegate = new CDTVideoRecorder(this.outputDirLocation, this.outputVideoName, videoConfig);
        }
    }

    @Override
    public void start() throws VideoRecorderException {
        if (this.isStarted()) {
            this.stop();
            this.reload();
        }
        this.delegate.start();
    }

    @Override
    public void stop() throws VideoRecorderException {
        if (!this.isStarted()) {
            return;
        }
        this.delegate.stop();
    }

    @Override
    public void pause() throws VideoRecorderException {
        this.delegate.pause();
    }

    @Override
    public void resume() throws VideoRecorderException {
        this.delegate.resume();
    }

    @Override
    public void reload() throws VideoRecorderException {
        this.delegate.reload();
    }

    @Override
    public boolean isStarted() {
        return this.delegate.isStarted();
    }

    @Override
    public boolean isInterrupted() {
        return this.delegate.isInterrupted();
    }

    @Override
    public String getCurrentVideoLocation() {
        return this.delegate.getCurrentVideoLocation();
    }

    @Override
    public long getStartTime() {
        return this.delegate.getStartTime();
    }

    @Override
    public void delete() {
        this.delegate.delete();
    }

    public AbstractVideoRecorder getDelegate() {
        return this.delegate;
    }
}

