/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.common.CommonExecutor;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TestCaseBindingExecutor
extends CommonExecutor {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private InternalTestSuiteContext testSuiteContext;
    private String testCaseId;
    protected ScriptEngine scriptEngine;
    protected ExecutionEventManager eventManger;

    public TestCaseBindingExecutor(String testCaseId, ScriptEngine scriptEngine, ExecutionEventManager eventManger) {
        this.testCaseId = testCaseId;
        this.scriptEngine = scriptEngine;
        this.eventManger = eventManger;
        this.testSuiteContext = new InternalTestSuiteContext();
        this.testSuiteContext.setTestSuiteId(testCaseId);
    }

    public void execute(File testCaseBindingFile) {
        this.logger.startTestCaseBinding(this.testCaseId);
        this.accessTestCaseBindingMainPhase(testCaseBindingFile);
        this.setStatusTestSuiteContext(this.testSuiteContext);
        this.logger.endTestCaseBinding(this.testCaseId);
    }

    private void accessTestCaseBindingMainPhase(File testCaseBindingFile) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        if (errorCollector.containsErrors()) {
            return;
        }
        try {
            List bindings = FileUtils.readLines((File)testCaseBindingFile, (String)"UTF-8");
            if (bindings.isEmpty()) {
                this.accessTestCaseMainPhase(1, new TestCaseBinding(this.testCaseId, Collections.emptyMap()));
            } else {
                int i = 0;
                while (i < bindings.size()) {
                    TestCaseBinding testCaseBinding = JsonUtil.fromJson((String)bindings.get(i), TestCaseBinding.class);
                    this.accessTestCaseMainPhaseLoop(this.scriptEngine, testCaseBinding);
                    this.accessTestCaseMainPhase(i, testCaseBinding);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            errorCollector.addError(e);
        }
    }

    @Override
    public TestCaseExecutor accessTestCaseMainPhaseBody(TestCaseBinding tcBinding, InternalTestCaseContext testCaseContext) {
        return new TestCaseExecutor(tcBinding, this.scriptEngine, this.eventManger, testCaseContext);
    }
}

