/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.html;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.reporting.html.JsModel;
import com.kms.katalon.core.reporting.html.JsModelProperty;
import com.kms.katalon.core.reporting.html.JsStepModel;
import com.kms.katalon.core.reporting.html.JsTestModel;
import java.util.ArrayList;
import java.util.List;

public class JsCallStepModel
extends JsModel {
    private TestStepLogRecord callerStep;
    private List<JsStepModel> callingSteps;
    private JsModel status;
    private List<String> listStrings;
    private JsTestModel testModel;
    private TestCaseLogRecord calledTest;

    public JsCallStepModel(TestStepLogRecord callerStep, TestCaseLogRecord testLog, List<String> listStrings) {
        this.callerStep = callerStep;
        this.calledTest = testLog;
        this.listStrings = listStrings;
        this.testModel = new JsTestModel(testLog, listStrings, callerStep);
    }

    private void init() {
        this.callingSteps = new ArrayList<JsStepModel>();
        this.status = new JsModel();
        this.props.add(new JsModelProperty("Type", "0", null));
        this.props.add(new JsModelProperty("name", this.calledTest.getName(), this.listStrings));
        this.props.add(new JsModelProperty("timeout", "0", null));
        this.props.add(new JsModelProperty("doc", "0", null));
        this.props.add(new JsModelProperty("args", "0", null));
        this.initStatus();
        ILogRecord[] iLogRecordArray = this.calledTest.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestStepLogRecord) {
                this.callingSteps.add(new JsStepModel((TestStepLogRecord)logRecord, this.listStrings, this.callerStep.getName()));
            }
            ++n2;
        }
    }

    @Override
    public StringBuilder toArrayString() {
        this.init();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JsModelProperty prop : this.props) {
            sb.append(prop.getPropertyValue());
            sb.append(",");
        }
        sb.append((CharSequence)this.status.toArrayString());
        sb.append(",");
        sb.append("[");
        int i = 0;
        while (i < this.testModel.getSteps().size()) {
            sb.append((CharSequence)this.testModel.getSteps().get(i).toArrayString());
            if (i < this.testModel.getSteps().size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        sb.append(",");
        sb.append("[]");
        sb.append("]");
        return sb;
    }

    public JsTestModel getTestModel() {
        return this.testModel;
    }

    private void initStatus() {
        long startTime = this.calledTest.getStartTime();
        long elapsedTime = this.calledTest.getEndTime() - startTime;
        TestStatus.TestStatusValue theStatus = this.calledTest.getStatus().getStatusValue();
        String statVal = "" + theStatus.ordinal();
        this.status.props.add(new JsModelProperty("status", statVal, null));
        this.status.props.add(new JsModelProperty("startTime", String.valueOf(startTime), null));
        this.status.props.add(new JsModelProperty("elapsedTime", String.valueOf(elapsedTime), null));
    }
}

