/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.newreport.analyzer;

import com.kms.katalon.report.core.models.common.ExecutedTestResult;
import com.kms.katalon.report.core.models.entities.ExecutedTestCase;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.report.core.models.entities.ExecutedTestSuite;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FailedEntityBuilder {
    public ExecutedTestEntity buildFailedTestEntity(ExecutedTestEntity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof ExecutedTestSuite) {
            return this.buildMinimalFailureContext((ExecutedTestSuite)entity);
        }
        return entity;
    }

    private ExecutedTestEntity buildMinimalFailureContext(ExecutedTestSuite originalSuite) {
        ExecutedTestSuite context = new ExecutedTestSuite();
        context.id = originalSuite.id;
        context.name = originalSuite.name;
        context.type = originalSuite.type;
        context.startTime = originalSuite.startTime;
        context.endTime = originalSuite.endTime;
        context.result = originalSuite.result;
        context.message = originalSuite.message;
        context.statistics = originalSuite.statistics;
        if (originalSuite.children != null) {
            context.children = (ExecutedTestEntity[])Optional.ofNullable(originalSuite.children).map(this::filterFinalTestCaseResults).stream().flatMap(Arrays::stream).map(this::buildMinimalTestCaseContext).toArray(ExecutedTestEntity[]::new);
        }
        return context;
    }

    private ExecutedTestCase buildMinimalTestCaseContext(ExecutedTestEntity child) {
        ExecutedTestCase minimalCase = new ExecutedTestCase();
        minimalCase.id = child.id;
        minimalCase.name = child.name;
        minimalCase.result = child.result;
        minimalCase.message = child.message;
        return minimalCase;
    }

    private boolean isFailedExecutedTestEntity(ExecutedTestEntity entity) {
        return entity != null && (entity.result == ExecutedTestResult.FAILED || entity.result == ExecutedTestResult.ERROR);
    }

    private ExecutedTestEntity[] filterFinalTestCaseResults(ExecutedTestEntity[] entities) {
        return (ExecutedTestEntity[])Arrays.stream(entities).filter(ExecutedTestCase.class::isInstance).filter(this::isFailedExecutedTestEntity).map(ExecutedTestCase.class::cast).collect(Collectors.groupingBy(testCase -> testCase.entityId, LinkedHashMap::new, Collectors.toList())).values().stream().map(this::getFinalTestCaseResult).toArray(ExecutedTestEntity[]::new);
    }

    private ExecutedTestEntity getFinalTestCaseResult(List<ExecutedTestCase> retryAttempts) {
        return retryAttempts.stream().max(Comparator.comparingInt(attempt -> attempt.retryCount)).orElse(null);
    }
}

