/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.pdf;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.pdf.AbstractPdfReportGenerator;
import com.kms.katalon.core.reporting.pdf.TestCasePdfGenerator;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.reporting.util.PDFUtils;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ExecutorUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.FileUtils;

public class TestSuitePdfGenerator
extends AbstractPdfReportGenerator {
    private static final int REPORT_PART_GENERATION_POOL_SIZE = 10;
    private TestSuiteLogRecord fTestSuiteLogRecord;

    public TestSuitePdfGenerator(TestSuiteLogRecord testSuiteLogRecord) {
        this.fTestSuiteLogRecord = testSuiteLogRecord;
    }

    @Override
    protected ILogRecord[] getLogRecords() {
        return this.fTestSuiteLogRecord.filterFinalTestCasesResult();
    }

    @Override
    protected String getPrimaryTemplateLocation() {
        return "resources/pdf/test_suite_tpl.jrxml";
    }

    @Override
    protected Map<String, Object> getAdditionalParams() {
        HashMap<String, Object> jasperParams = new HashMap<String, Object>();
        jasperParams.put("TEST_SUITE", this.fTestSuiteLogRecord);
        return jasperParams;
    }

    @Override
    public File exportToPDF(String fileLocation) throws JasperReportException, IOException {
        String reportFolder = this.fTestSuiteLogRecord.getLogFolder();
        File tempReportFolder = Files.createTempDirectory("katalon-report-", new FileAttribute[0]).toFile();
        ArrayList<String> reportParts = new ArrayList<String>();
        try {
            String suiteLocation = new File(tempReportFolder, "ts.pdf").getAbsolutePath();
            super.exportToPDF(suiteLocation, "resources/pdf/test_suite_tpl.jrxml");
            reportParts.add(suiteLocation);
            List<String> testCaseParts = this.generateTestCaseParts(tempReportFolder, reportFolder);
            reportParts.addAll(testCaseParts);
            PDFUtils.mergePDFs(fileLocation, reportParts.toArray(new String[0]));
        }
        finally {
            FileUtils.deleteQuietly((File)tempReportFolder);
        }
        return new File(fileLocation);
    }

    private List<String> generateTestCaseParts(File tempReportFolder, String reportFolder) {
        List<String> reportParts = Collections.synchronizedList(new ArrayList());
        ILogRecord[] testCaseLogRecords = this.fTestSuiteLogRecord.filterFinalTestCasesResult();
        ForkJoinPool generateTestCaseDetailsPool = ExecutorUtils.createForkJoinPool((int)10);
        int testCaseIndex = 0;
        ILogRecord[] iLogRecordArray = testCaseLogRecords;
        int n = testCaseLogRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord testCaseLogRecord = iLogRecordArray[n2];
            if (testCaseLogRecord instanceof TestCaseLogRecord) {
                String tempTestCaseName = MessageFormat.format("tc-{0}.pdf", testCaseIndex++);
                String tempTestCasePath = new File(tempReportFolder, tempTestCaseName).getAbsolutePath();
                reportParts.add(tempTestCasePath);
                generateTestCaseDetailsPool.submit(() -> {
                    TestCasePdfGenerator testCasePDFGenerator = new TestCasePdfGenerator((TestCaseLogRecord)testCaseLogRecord, reportFolder);
                    try {
                        testCasePDFGenerator.exportToPDF(tempTestCasePath);
                    }
                    catch (JasperReportException | IOException error) {
                        LogUtil.logError((Throwable)error);
                        reportParts.remove(tempTestCasePath);
                    }
                });
            }
            ++n2;
        }
        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)generateTestCaseDetailsPool);
        return reportParts;
    }
}

