/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata.reader;

import com.kms.katalon.core.testdata.ExcelData;
import com.kms.katalon.core.testdata.InternalData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLTableData
extends ExcelData {
    private InternalData internalData;
    private String sheetName;
    private List<String> columnNames;
    private List<String[]> dataBody;

    public HTMLTableData(String sourceUrl, boolean hasHeaders) throws IOException {
        super(sourceUrl, hasHeaders);
        this.sheetName = FilenameUtils.getBaseName((String)sourceUrl);
    }

    @Override
    public String[] getColumnNames() throws IOException {
        return this.getInternalData().getColumnNames();
    }

    @Override
    public int getRowNumbers() throws IOException {
        return this.getInternalData().getRowNumbers();
    }

    @Override
    public int getColumnNumbers() throws IOException {
        return this.getInternalData().getColumnNumbers();
    }

    InternalData getInternalData() throws IOException {
        if (this.internalData == null) {
            Document doc = Jsoup.parse((File)new File(this.sourceUrl), null);
            Elements tables = doc.getElementsByTag("table");
            if (tables == null || tables.isEmpty()) {
                throw new IllegalArgumentException("No table found.");
            }
            Element table = tables.first();
            Elements headers = table.getElementsByTag("thead");
            if (headers == null || headers.isEmpty()) {
                throw new IllegalArgumentException("No thead found.");
            }
            Elements bodys = table.getElementsByTag("tbody");
            if (bodys == null || bodys.isEmpty()) {
                throw new IllegalArgumentException("No tbody found.");
            }
            Elements headerElements = headers.first().getElementsByTag("tr").first().getElementsByTag("th");
            Elements bodyRows = bodys.first().getElementsByTag("tr");
            this.columnNames = this.collectColumnNames(headerElements);
            this.dataBody = this.collectData(bodyRows);
            this.createInternalData();
        }
        return this.internalData;
    }

    private void createInternalData() {
        ArrayList<String> columnNamesCoppied = new ArrayList<String>(this.columnNames);
        ArrayList<String[]> dataBodyCoppied = new ArrayList<String[]>(this.dataBody);
        if (this.hasHeaders) {
            this.internalData = new InternalData(this.getSourceUrl(), dataBodyCoppied, columnNamesCoppied);
        } else {
            dataBodyCoppied.add(0, columnNamesCoppied.toArray(new String[columnNamesCoppied.size()]));
            this.internalData = new InternalData(this.getSourceUrl(), dataBodyCoppied, Arrays.asList(ArrayUtils.nullToEmpty((String[])new String[columnNamesCoppied.size()])));
        }
    }

    private List<String> collectColumnNames(Elements headerElements) {
        ArrayList<String> columnNames = new ArrayList<String>(headerElements.size());
        int colIdx = 0;
        while (colIdx < headerElements.size()) {
            columnNames.add(((Element)headerElements.get(colIdx)).text());
            ++colIdx;
        }
        return columnNames;
    }

    private List<String[]> collectData(Elements bodyRows) {
        ArrayList<String[]> data = new ArrayList<String[]>(bodyRows.size());
        int rowIdx = 0;
        while (rowIdx < bodyRows.size()) {
            Elements cellsAtRowIdx = ((Element)bodyRows.get(rowIdx)).getElementsByTag("td");
            String[] valuesAtRowIdx = new String[cellsAtRowIdx.size()];
            int colIdx = 0;
            while (colIdx < cellsAtRowIdx.size()) {
                valuesAtRowIdx[colIdx] = ((Element)cellsAtRowIdx.get(colIdx)).text();
                ++colIdx;
            }
            data.add(valuesAtRowIdx);
            ++rowIdx;
        }
        return data;
    }

    @Override
    public String[] getSheetNames() {
        return new String[]{this.sheetName};
    }

    @Override
    public void changeSheet(String sheetName) {
    }

    @Override
    public int getMaxColumn(int rowIndex) throws IOException {
        return this.getInternalData().getColumnNumbers();
    }

    @Override
    protected String internallyGetValue(String columnName, int rowIndex) throws IOException {
        return this.getInternalData().internallyGetValue(columnName, rowIndex);
    }

    @Override
    protected String internallyGetValue(int columnIdx, int rowIndex) throws IOException {
        return this.getInternalData().internallyGetValue(columnIdx, rowIndex);
    }

    @Override
    public void activeHeaders(boolean active) throws IOException {
        super.activeHeaders(active);
        if (this.internalData == null) {
            return;
        }
        this.createInternalData();
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }
}

