/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata.reader;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testdata.ExcelData;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetPOI
extends ExcelData {
    private static final int COLUMN_HEADER_ROW_NUMBER = 0;
    private Workbook workbook;
    private Sheet sheet;
    private int columnCount = -1;
    private String sheetName;
    private List<CellRangeAddress> mergedRegionsList;
    private String[] columnNames;

    public SheetPOI(String sourceUrl, boolean hasHeaders, Workbook workbook) throws IOException {
        super(sourceUrl, hasHeaders);
        this.workbook = workbook;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    private Sheet getSheet() throws IOException {
        if (this.sheet == null) {
            throw new IOException(StringConstants.EXC_MSG_EXCEL_CANNOT_FIND_SHEET);
        }
        return this.sheet;
    }

    private List<CellRangeAddress> getMergedRegions() throws IOException {
        if (this.mergedRegionsList == null) {
            this.mergedRegionsList = new ArrayList<CellRangeAddress>();
            int i = 0;
            while (i < this.getSheet().getNumMergedRegions()) {
                this.mergedRegionsList.add(this.getSheet().getMergedRegion(i));
                ++i;
            }
        }
        return this.mergedRegionsList;
    }

    @Override
    protected Object internallyGetValue(int col, int row) throws IOException {
        int maxRow = this.getRowNumbers();
        if (row > maxRow) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXCEL_INVALID_ROW_NUMBER, row, maxRow));
        }
        int maxColumnAtRow = this.getMaxColumn(row + this.getHeaderRowIdx());
        if (maxColumnAtRow < 0) {
            return null;
        }
        if (col > maxColumnAtRow) {
            return null;
        }
        for (CellRangeAddress mergedRegion : this.getMergedRegions()) {
            if (!mergedRegion.isInRange(row, col)) continue;
            return this.getCellAt(mergedRegion.getFirstColumn(), mergedRegion.getFirstRow());
        }
        return this.getCellAt(col, row + this.getHeaderRowIdx());
    }

    private Object getCellAt(int col, int row) {
        Row curRow = this.sheet.getRow(row);
        if (curRow == null) {
            return null;
        }
        Cell curCell = curRow.getCell(col);
        if (curCell == null) {
            return null;
        }
        String readAsString = this.getProperty("readAsString");
        if (readAsString == null || Boolean.valueOf(readAsString).booleanValue()) {
            return this.decorateExcelCellAsString(this.workbook, curCell);
        }
        return this.decorateExcelCellAsIs(this.workbook, curCell);
    }

    protected int getColumnIndex(String colName) throws IOException {
        if (colName == null) {
            throw new IllegalArgumentException("Column name cannot be null");
        }
        String[] columnNames = this.getColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            if (colName.equals(columnNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected Object internallyGetValue(String colName, int row) throws IOException {
        int col = this.getColumnIndex(colName);
        if (col < 0) {
            throw new IllegalArgumentException("Column not found");
        }
        Object value = this.internallyGetValue(col, row);
        return value;
    }

    @Override
    public int getMaxColumn(int rowIndex) {
        Row curRow = this.sheet.getRow(rowIndex);
        if (curRow != null) {
            return curRow.getLastCellNum();
        }
        return -1;
    }

    @Override
    public String[] getColumnNames() throws IOException {
        if (ArrayUtils.isEmpty((Object[])this.columnNames)) {
            int maxColumnCounts = this.getColumnCount();
            if (maxColumnCounts < 0) {
                return new String[0];
            }
            this.columnNames = new String[maxColumnCounts];
            if (this.hasHeaders) {
                int i = 0;
                while (i < maxColumnCounts) {
                    this.columnNames[i] = (String)this.getCellAt(i, 0);
                    ++i;
                }
            }
        }
        return this.columnNames;
    }

    private int getColumnCount() throws IOException {
        if (this.columnCount < 0) {
            int rowIndex = 0;
            while (rowIndex < this.getTotalRows()) {
                int maxColumnRow = this.getMaxColumn(rowIndex);
                if (maxColumnRow > this.columnCount) {
                    this.columnCount = maxColumnRow;
                }
                ++rowIndex;
            }
        }
        return Math.max(0, this.columnCount);
    }

    @Override
    public String[] getSheetNames() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[numberOfSheets];
        int i = 0;
        while (i < numberOfSheets) {
            sheetNames[i] = this.workbook.getSheetName(i);
            ++i;
        }
        return sheetNames;
    }

    @Override
    public void changeSheet(String sheetName) {
        this.sheet = this.workbook.getSheet(sheetName);
        this.mergedRegionsList = null;
        this.columnNames = null;
        this.columnCount = -1;
    }

    @Override
    public int getRowNumbers() throws IOException {
        int totalRows = this.getSheet().getLastRowNum() + 1;
        return totalRows - this.getHeaderRowIdx();
    }

    private int getTotalRows() throws IOException {
        return this.getSheet().getLastRowNum() + 1;
    }

    @Override
    public int getColumnNumbers() throws IOException {
        return this.getColumnCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String decorateExcelCellAsString(Workbook workbook, Cell curCell) {
        if (curCell == null) {
            return "";
        }
        switch (curCell.getCellType()) {
            case 1: {
                return curCell.getRichStringCellValue().getString();
            }
            case 0: {
                DataFormatter formatter = new DataFormatter(Locale.getDefault());
                return formatter.formatRawCellContents(curCell.getNumericCellValue(), -1, SheetPOI.getFormatString(curCell.getCellStyle().getDataFormatString()));
            }
            case 4: {
                return Boolean.toString(curCell.getBooleanCellValue());
            }
            case 2: {
                FormulaEvaluator formulaEval = null;
                try {
                    formulaEval = workbook.getCreationHelper().createFormulaEvaluator();
                    CellValue cellVal = formulaEval.evaluate(curCell);
                    switch (cellVal.getCellType()) {
                        case 3: {
                            return "";
                        }
                        case 1: {
                            return cellVal.getStringValue();
                        }
                        case 0: {
                            DataFormatter formatter = new DataFormatter(Locale.getDefault());
                            return formatter.formatRawCellContents(cellVal.getNumberValue(), -1, SheetPOI.getFormatString(curCell.getCellStyle().getDataFormatString()));
                        }
                    }
                    return cellVal.formatAsString();
                }
                catch (Exception exception) {
                    try {
                        if (DateUtil.isCellDateFormatted((Cell)curCell)) {
                            String cellFormatString = curCell.getCellStyle().getDataFormatString();
                            return new CellDateFormatter(cellFormatString).simpleFormat((Object)curCell.getDateCellValue());
                        }
                        DataFormatter formatter = new DataFormatter(Locale.getDefault());
                        return formatter.formatRawCellContents(curCell.getNumericCellValue(), -1, SheetPOI.getFormatString(curCell.getCellStyle().getDataFormatString()));
                    }
                    catch (Exception exception2) {
                        return curCell.getStringCellValue();
                    }
                }
            }
        }
        return curCell.getStringCellValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object decorateExcelCellAsIs(Workbook workbook, Cell curCell) {
        if (curCell == null) {
            return null;
        }
        switch (curCell.getCellType()) {
            case 1: {
                return curCell.getRichStringCellValue().getString();
            }
            case 0: {
                return curCell.getNumericCellValue();
            }
            case 4: {
                return curCell.getBooleanCellValue();
            }
            case 2: {
                FormulaEvaluator formulaEval = null;
                try {
                    formulaEval = workbook.getCreationHelper().createFormulaEvaluator();
                    CellValue cellVal = formulaEval.evaluate(curCell);
                    switch (cellVal.getCellType()) {
                        case 3: {
                            return "";
                        }
                        case 1: {
                            return cellVal.getStringValue();
                        }
                        case 0: {
                            return cellVal.getNumberValue();
                        }
                    }
                    return cellVal.formatAsString();
                }
                catch (Exception exception) {
                    try {
                        if (DateUtil.isCellDateFormatted((Cell)curCell)) {
                            return curCell.getDateCellValue();
                        }
                        return curCell.getNumericCellValue();
                    }
                    catch (Exception exception2) {
                        return curCell.getStringCellValue();
                    }
                }
            }
        }
        return curCell.getStringCellValue();
    }

    private static String getFormatString(String rawFormatString) {
        if (rawFormatString == null || rawFormatString.isEmpty()) {
            return rawFormatString;
        }
        return rawFormatString.replace("_(*", "_(\"\"*");
    }
}

