/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.http.HttpUtils;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.core.testobject.ValidationStep;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.core.testobject.authorization.AwsSignatureAuthorization;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.DigestAuthorization;
import com.kms.katalon.core.testobject.authorization.NTLMAuthorization;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.testobject.internal.impl.HttpBodyContentReader;
import com.kms.katalon.core.testobject.internal.impl.WindowsObjectRepository;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.StrSubstitutor;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.util.CryptoUtil;
import com.kms.katalon.util.SAXReaderProvider;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import groovy.lang.Binding;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ObjectRepository {
    private static final KeywordLogger logger = KeywordLogger.getInstance(ObjectRepository.class);
    private static final String TEST_OBJECT_ROOT_FOLDER_NAME = "Object Repository";
    private static final String TEST_OBJECT_ID_PREFIX = "Object Repository/";
    private static final String WEB_SERVICES_TYPE_NAME = "WebServiceRequestEntity";
    private static final String WEB_ELEMENT_TYPE_NAME = "WebElementEntity";
    private static final String MOBILE_ELEMENT_TYPE_NAME = "MobileElementEntity";
    private static final String WINDOWS_ELEMENT_TYPE_NAME = "WindowsElementEntity";
    private static final String WEBELEMENT_FILE_EXTENSION = ".rs";
    private static final String WEB_ELEMENT_PROPERTY_NODE_NAME = "webElementProperties";
    private static final String WEB_ELEMENT_XPATH_NODE_NAME = "webElementXpaths";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_CONDITION = "matchCondition";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_IS_SELECTED = "isSelected";
    private static final String[] PARENT_FRAME_ATTRS = new String[]{"ref_element", "parent_frame"};
    private static final String PARENT_SHADOW_ROOT_ATTRIBUTE = "ref_element_is_shadow_root";
    private static final String PROPERTY_SELECTOR_METHOD = "selectorMethod";
    private static final String PROPERTY_SELECTOR_COLLECTION = "selectorCollection";
    private static final String PROPERTY_LOCATOR_COLLECTION = "locatorCollection";
    private static final String PROPERTY_ELEMENT_PROPERTIES = "webElementProperties";
    private static final String SMART_PROPERTY_SELECTOR_COLLECTION = "smartLocatorCollection";
    private static final String PROPERTY_ENTRY = "entry";
    private static final String PROPERTY_KEY = "key";
    private static final String API_COLLECTION_META_EXTENSION = ".meta";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTH_TYPE_BASIC = "Basic";
    private static final String AUTH_TYPE_BEARER = "Bearer";
    private static final String AUTH_TYPE_OAUTH_1_0 = "OAuth 1.0";
    private static final String AUTH_TYPE_OAUTH_2_0 = "OAuth 2.0";
    private static final String AUTH_TYPE_NTLM = "NTLM";
    private static final String AUTH_TYPE_AWS_SIGNATURE = "AWS Signature";
    private static final String AUTH_TYPE_DIGEST = "Digest";
    private static Object globalVariable;
    private static ScriptEngine scriptEngine;
    private static Map<String, TestObject> recordedTestObjects;

    private static ScriptEngine getScriptEngine() {
        if (scriptEngine != null) {
            return scriptEngine;
        }
        try {
            scriptEngine = ScriptEngine.getDefault(ObjectRepository.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create script engine", e);
        }
        return scriptEngine;
    }

    public static Object getGlobalVariable() {
        if (globalVariable != null) {
            return globalVariable;
        }
        try {
            ScriptEngine scriptEngine = ObjectRepository.getScriptEngine();
            globalVariable = scriptEngine.runScriptWithoutLogging("internal.GlobalVariable", new Binding());
        }
        catch (ResourceException | ScriptException | IOException | ClassNotFoundException e) {
            throw new RuntimeException("Cannot evaluate global variable", e);
        }
        return globalVariable;
    }

    public static String getTestObjectId(String testObjectRelativeId) {
        if (testObjectRelativeId == null) {
            return null;
        }
        if (testObjectRelativeId.startsWith(TEST_OBJECT_ID_PREFIX)) {
            return testObjectRelativeId;
        }
        return TEST_OBJECT_ID_PREFIX + testObjectRelativeId;
    }

    public static String getTestObjectRelativeId(String testObjectId) {
        if (testObjectId == null) {
            return null;
        }
        return testObjectId.replaceFirst(TEST_OBJECT_ID_PREFIX, "");
    }

    public static TestObject findTestObject(String testObjectRelativeId) {
        return ObjectRepository.findTestObject(testObjectRelativeId, new HashMap<String, Object>());
    }

    public static TestObject findTestObject(String testObjectRelativeId, Map<String, Object> variables) {
        File objectFile;
        if (testObjectRelativeId == null) {
            logger.logWarning(StringConstants.TO_LOG_WARNING_TEST_OBJ_NULL);
            return null;
        }
        String testObjectId = ObjectRepository.getTestObjectId(testObjectRelativeId);
        logger.logDebug(MessageFormat.format(StringConstants.TO_LOG_INFO_FINDING_TEST_OBJ_W_ID, testObjectId));
        if (RunConfiguration.isPlayback()) {
            Map<String, TestObject> testObjectsCached = ObjectRepository.getCapturedTestObjects();
            if (testObjectRelativeId != null && testObjectsCached != null && testObjectsCached.containsKey(testObjectRelativeId)) {
                return testObjectsCached.get(testObjectRelativeId);
            }
        }
        if (!(objectFile = new File(RunConfiguration.getProjectDir(), testObjectId + WEBELEMENT_FILE_EXTENSION)).exists()) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_TEST_OBJ_DOES_NOT_EXIST, testObjectId));
            return null;
        }
        return ObjectRepository.readTestObjectFile(testObjectId, objectFile, RunConfiguration.getProjectDir(), variables);
    }

    public static WindowsTestObject findWindowsObject(String windowsObjectRelativeId) {
        return ObjectRepository.findWindowsObject(windowsObjectRelativeId, Collections.emptyMap());
    }

    public static WindowsTestObject findWindowsObject(String windowsObjectRelativeId, Map<String, Object> variables) {
        String windowsObjectId = ObjectRepository.getTestObjectId(windowsObjectRelativeId);
        File objectFile = new File(RunConfiguration.getProjectDir(), windowsObjectId + ".wrs");
        return WindowsObjectRepository.readWindowsTestObjectFile(windowsObjectId, objectFile, RunConfiguration.getProjectDir(), variables);
    }

    private static Map<String, TestObject> getCapturedTestObjects() {
        if (recordedTestObjects != null) {
            return recordedTestObjects;
        }
        try {
            String capturedObjectCacheFilePath = StringUtils.defaultString((String)RunConfiguration.getCapturedObjectsCacheFile());
            if (!capturedObjectCacheFilePath.isEmpty()) {
                File capturedObjectCacheFile = new File(capturedObjectCacheFilePath);
                recordedTestObjects = (Map)JsonUtil.fromJson(FileUtils.readFileToString((File)capturedObjectCacheFile, (String)"UTF-8"), new TypeToken<Map<String, TestObject>>(){}.getType());
            }
        }
        catch (IOException iOException) {
            recordedTestObjects = Collections.emptyMap();
        }
        return recordedTestObjects;
    }

    public static TestObject readTestObjectFile(String testObjectId, File objectFile, String projectDir) {
        return ObjectRepository.readTestObjectFile(testObjectId, objectFile, projectDir, Collections.emptyMap());
    }

    public static TestObject readTestObjectFile(String testObjectId, File objectFile, String projectDir, Map<String, Object> variables) {
        try {
            Element rootElement = new SAXReader().read(objectFile).getRootElement();
            String elementName = rootElement.getName();
            if (WEB_ELEMENT_TYPE_NAME.equals(elementName)) {
                return ObjectRepository.findWebUIObject(testObjectId, rootElement, variables);
            }
            if (WEB_SERVICES_TYPE_NAME.equals(elementName)) {
                return ObjectRepository.findRequestObject(testObjectId, rootElement, projectDir, variables);
            }
            if (MOBILE_ELEMENT_TYPE_NAME.equals(elementName)) {
                return ObjectRepository.findMobileTestObject(testObjectId, rootElement, projectDir, variables);
            }
            return null;
        }
        catch (DocumentException e) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_CANNOT_GET_TEST_OBJECT_X_BECAUSE_OF_Y, testObjectId, ExceptionsUtil.getMessageForThrowable(e)), null, e);
            return null;
        }
    }

    private static TestObject findWebUIObject(String testObjectId, Element element, Map<String, Object> variables) {
        TestObject parentObject;
        boolean isPropertySelected;
        String propertyValue;
        ConditionType propertyCondition;
        String propertyName;
        Element smartSelectorCollection;
        List selectorEntry;
        Element dfSelectorMethodElement;
        Element relativeImagePathElement;
        TestObject testObject = new TestObject(testObjectId);
        Element imagePathElement = element.element("imagePath");
        if (imagePathElement != null) {
            String imagePath = imagePathElement.getText();
            testObject.setImagePath(imagePath);
        }
        if ((relativeImagePathElement = element.element("useRalativeImagePath")) != null) {
            String useRelavitePathString = relativeImagePathElement.getText();
            testObject.setUseRelativeImagePath(Boolean.parseBoolean(useRelavitePathString));
        }
        Element elementIsSmartLocatorEnabled = element.element("smartLocatorEnabled");
        boolean isSmartLocatorEnabled = false;
        if (elementIsSmartLocatorEnabled != null) {
            isSmartLocatorEnabled = Boolean.valueOf(elementIsSmartLocatorEnabled.getText());
        }
        if ((dfSelectorMethodElement = element.element(PROPERTY_SELECTOR_METHOD)) != null) {
            if (isSmartLocatorEnabled) {
                testObject.setSelectorMethod(SelectorMethod.SMART_LOCATOR);
            } else {
                testObject.setSelectorMethod(SelectorMethod.valueOf(dfSelectorMethodElement.getText()));
            }
        }
        HashMap<String, Object> variablesStringMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry2 : variables.entrySet()) {
            variablesStringMap.put(String.valueOf(entry2.getKey()), entry2.getValue());
        }
        Object globalVariable = ObjectRepository.getGlobalVariable();
        if (globalVariable != null) {
            variablesStringMap.put("GlobalVariable", globalVariable);
        }
        StrSubstitutor strSubtitutor = new StrSubstitutor(variablesStringMap);
        Element propertySelectorCollection = element.element(PROPERTY_SELECTOR_COLLECTION);
        if (propertySelectorCollection != null && (selectorEntry = propertySelectorCollection.elements(PROPERTY_ENTRY)) != null) {
            selectorEntry.forEach(entry -> {
                Element selectorMethodElement = (Element)entry;
                SelectorMethod entryKey = SelectorMethod.valueOf(selectorMethodElement.elementText(PROPERTY_KEY));
                String entryValue = strSubtitutor.replace(selectorMethodElement.elementText(PROPERTY_VALUE));
                testObject.setSelectorValue(entryKey, entryValue);
            });
        }
        if ((smartSelectorCollection = element.element(SMART_PROPERTY_SELECTOR_COLLECTION)) != null) {
            List selectorEntry2 = smartSelectorCollection.elements(PROPERTY_ENTRY);
            HashMap<SelectorMethod, String> map = new HashMap<SelectorMethod, String>();
            if (selectorEntry2 != null) {
                selectorEntry2.forEach(entry -> {
                    Element selectorMethodElement = (Element)entry;
                    SelectorMethod entryKey = SelectorMethod.valueOf(selectorMethodElement.elementText(PROPERTY_KEY));
                    String entryValue = strSubtitutor.replace(selectorMethodElement.elementText(PROPERTY_VALUE));
                    map.put(entryKey, entryValue);
                });
                testObject.setSmartSelectorCollection(map);
            }
        }
        for (Object propertyElementObject : element.elements("webElementProperties")) {
            TestObjectProperty objectProperty = new TestObjectProperty();
            Element propertyElement = (Element)propertyElementObject;
            propertyName = StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_NAME));
            propertyCondition = ConditionType.fromValue(StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_CONDITION)));
            propertyValue = StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_VALUE));
            isPropertySelected = Boolean.valueOf(StringEscapeUtils.unescapeXml((String)propertyElement.elementText(PROPERTY_IS_SELECTED)));
            objectProperty.setName(propertyName);
            objectProperty.setCondition(propertyCondition);
            objectProperty.setValue(strSubtitutor.replace(propertyValue));
            objectProperty.setActive(isPropertySelected);
            if (Arrays.asList(PARENT_FRAME_ATTRS).contains(propertyName) && isPropertySelected) {
                parentObject = ObjectRepository.findTestObject(propertyValue);
                testObject.setParentObject(parentObject);
                continue;
            }
            if (PARENT_SHADOW_ROOT_ATTRIBUTE.equals(propertyName)) {
                testObject.setParentObjectShadowRoot(true);
                continue;
            }
            testObject.addProperty(objectProperty);
        }
        for (Object xpathElementObject : element.elements(WEB_ELEMENT_XPATH_NODE_NAME)) {
            TestObjectXpath objectXpath = new TestObjectXpath();
            Element xpathElement = (Element)xpathElementObject;
            propertyName = StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_NAME));
            propertyCondition = ConditionType.fromValue(StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_CONDITION)));
            propertyValue = StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_VALUE));
            isPropertySelected = Boolean.valueOf(StringEscapeUtils.unescapeXml((String)xpathElement.elementText(PROPERTY_IS_SELECTED)));
            objectXpath.setName(propertyName);
            objectXpath.setCondition(propertyCondition);
            objectXpath.setValue(strSubtitutor.replace(propertyValue));
            objectXpath.setActive(isPropertySelected);
            if (Arrays.asList(PARENT_FRAME_ATTRS).contains(propertyName) && isPropertySelected) {
                parentObject = ObjectRepository.findTestObject(propertyValue);
                testObject.setParentObject(parentObject);
                continue;
            }
            if (PARENT_SHADOW_ROOT_ATTRIBUTE.equals(propertyName)) {
                testObject.setParentObjectShadowRoot(true);
                continue;
            }
            testObject.addXpath(objectXpath);
        }
        return testObject;
    }

    private static MobileTestObject findMobileTestObject(String mobileObjectId, Element element, String projectDir, Map<String, Object> variables) {
        List locatorEntry;
        MobileTestObject mobileTestObject = new MobileTestObject(mobileObjectId);
        String locator = element.elementText("locator");
        HashMap<String, Object> variablesStringMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry2 : variables.entrySet()) {
            variablesStringMap.put(String.valueOf(entry2.getKey()), entry2.getValue());
        }
        Object globalVariable = ObjectRepository.getGlobalVariable();
        if (globalVariable != null) {
            variablesStringMap.put("GlobalVariable", globalVariable);
        }
        MobilePlatform platform = null;
        String propertyPlatform = element.elementText("platform");
        if (StringUtils.isNotEmpty((String)propertyPlatform)) {
            platform = MobilePlatform.valueOf(propertyPlatform);
        } else {
            String devicePlatform = RunConfiguration.getDevicePlatform();
            if (StringUtils.isNotEmpty((String)devicePlatform)) {
                if ("ANDROID_DRIVER".equals(devicePlatform)) {
                    platform = MobilePlatform.ANDROID;
                } else if ("IOS_DRIVER".equals(devicePlatform)) {
                    platform = MobilePlatform.IOS;
                }
            }
        }
        if (platform == null) {
            List<TestObjectProperty> properties = mobileTestObject.getProperties();
            boolean isAndroid = properties.stream().anyMatch(p -> p.getName().equals("class"));
            platform = isAndroid ? MobilePlatform.ANDROID : MobilePlatform.IOS;
        }
        mobileTestObject.setPlatform(platform);
        StrSubstitutor strSubstitutor = new StrSubstitutor(variablesStringMap);
        mobileTestObject.setLocator(strSubstitutor.replace(locator));
        String locatorStrategyStr = element.elementText("locatorStrategy");
        LocatorStrategy locatorStrategy = LocatorStrategy.valueOf(locatorStrategyStr);
        mobileTestObject.setLocatorStrategy(locatorStrategy);
        List elementProperties = element.elements("webElementProperties");
        List<TestObjectProperty> properties = elementProperties.stream().map(e -> {
            String isSelected = e.elementText(PROPERTY_IS_SELECTED);
            String name = e.elementText(PROPERTY_NAME);
            String value = e.elementText(PROPERTY_VALUE);
            String condition = e.elementText(PROPERTY_CONDITION);
            return new TestObjectProperty(name, ConditionType.fromValue(condition), value, Boolean.parseBoolean(isSelected));
        }).collect(Collectors.toList());
        mobileTestObject.setProperties(properties);
        Element propertyLocatorCollection = element.element(PROPERTY_LOCATOR_COLLECTION);
        if (propertyLocatorCollection != null && (locatorEntry = propertyLocatorCollection.elements(PROPERTY_ENTRY)) != null) {
            locatorEntry.forEach(entry -> {
                Element locatoStrategyElement = (Element)entry;
                String key = locatoStrategyElement.elementText(PROPERTY_KEY);
                if (StringUtils.isNotEmpty((String)key)) {
                    LocatorStrategy entryKey = LocatorStrategy.valueOf(key);
                    String entryValue = strSubstitutor.replace(locatoStrategyElement.elementText(PROPERTY_VALUE));
                    mobileTestObject.setLocatorValue(entryKey, entryValue);
                }
            });
        }
        return mobileTestObject;
    }

    private static RequestObject findRequestObject(String requestObjectId, Element reqElement, String projectDir, Map<String, Object> variables) {
        BasicRequestAuthorization inheritedAuth;
        Object globalVariable;
        Map<Object, Object> defaultVariables;
        String serviceType;
        RequestObject requestObject;
        block22: {
            requestObject = new RequestObject(requestObjectId);
            requestObject.setName(reqElement.elementText(PROPERTY_NAME));
            serviceType = reqElement.elementText("serviceType");
            requestObject.setServiceType(serviceType);
            defaultVariables = new HashMap();
            List variableElements = reqElement.elements("variables");
            if (variableElements != null && variableElements.size() > 0) {
                HashMap<String, String> rawVariables = new HashMap<String, String>();
                for (Element variableElement : variableElements) {
                    if (variableElement == null) continue;
                    Element defaultValue = variableElement.element("defaultValue");
                    Element name = variableElement.element(PROPERTY_NAME);
                    if (defaultValue.equals("")) continue;
                    rawVariables.put(name.getData().toString(), defaultValue.getData().toString());
                }
                boolean exception = false;
                try {
                    try {
                        defaultVariables = ObjectRepository.evaluateVariables(rawVariables);
                    }
                    catch (Exception exception2) {
                        exception = true;
                        if (exception) {
                            defaultVariables = new HashMap();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (exception) {
                        defaultVariables = new HashMap();
                    }
                    throw throwable;
                }
                if (exception) {
                    defaultVariables = new HashMap();
                }
            }
        }
        HashMap<String, Object> mergedVariables = new HashMap<String, Object>();
        mergedVariables.putAll(defaultVariables);
        if (variables != null && variables.size() > 0) {
            mergedVariables.putAll(variables);
        }
        if ((globalVariable = ObjectRepository.getGlobalVariable()) != null) {
            mergedVariables.put("GlobalVariable", globalVariable);
        }
        StrSubstitutor substitutor = new StrSubstitutor(mergedVariables);
        if ("SOAP".equals(serviceType)) {
            requestObject.setWsdlAddress(substitutor.replace(reqElement.elementText("wsdlAddress")));
            requestObject.setSoapRequestMethod(reqElement.elementText("soapRequestMethod"));
            requestObject.setSoapServiceFunction(reqElement.elementText("soapServiceFunction"));
            requestObject.setHttpHeaderProperties(ObjectRepository.parseProperties(reqElement.elements("httpHeaderProperties"), substitutor));
            requestObject.setSoapBody(substitutor.replace(reqElement.elementText("soapBody")));
            String useServiceInfoFromWsdlValue = reqElement.elementText("useServiceInfoFromWsdl");
            if (StringUtils.isNotBlank((String)useServiceInfoFromWsdlValue)) {
                requestObject.setUseServiceInfoFromWsdl(Boolean.valueOf(StringEscapeUtils.unescapeXml((String)useServiceInfoFromWsdlValue)));
            } else {
                requestObject.setUseServiceInfoFromWsdl(false);
            }
            requestObject.setSoapServiceEndpoint(substitutor.replace(reqElement.elementText("soapServiceEndpoint")));
        } else if ("RESTful".equals(serviceType)) {
            String rawUrl = reqElement.elementText("restUrl");
            String url = ObjectRepository.buildUrlFromRaw(rawUrl, substitutor);
            requestObject.setRestUrl(url);
            String requestMethod = reqElement.elementText("restRequestMethod");
            requestObject.setRestRequestMethod(requestMethod);
            requestObject.setRestParameters(ObjectRepository.parseProperties(reqElement.elements("restParameters")));
            requestObject.setHttpHeaderProperties(ObjectRepository.parseProperties(reqElement.elements("httpHeaderProperties"), substitutor));
            String httpBodyType = reqElement.elementText("httpBodyType");
            String oldVersionBodyContent = reqElement.elementText("httpBody");
            if (StringUtils.isNotBlank((String)oldVersionBodyContent)) {
                httpBodyType = "text";
                String body = reqElement.elementText("httpBody");
                HttpTextBodyContent httpBodyContent = new HttpTextBodyContent(body);
                requestObject.setBodyContent(httpBodyContent);
            } else if (StringUtils.isNotBlank((String)httpBodyType)) {
                String httpBodyContent = reqElement.elementText("httpBodyContent");
                HttpBodyContent bodyContent = HttpBodyContentReader.fromSource(httpBodyType, httpBodyContent, projectDir, substitutor);
                requestObject.setBodyContent(bodyContent);
            }
        }
        requestObject.setVariables(mergedVariables);
        RequestAuthorization requestAuthorization = ObjectRepository.parseAuthorization(reqElement.elements("authorizationRequest"));
        if ("RESTful".equals(serviceType) && requestAuthorization == null && !ObjectRepository.hasAuthorizationHeaders(requestObject) && (inheritedAuth = ObjectRepository.findInheritedAuthorizationFromPath(requestObjectId, projectDir)) != null) {
            ObjectRepository.applyInheritedAuthorization(requestObject, inheritedAuth);
            requestAuthorization = inheritedAuth;
        }
        requestObject.setRequestAuthorization(requestAuthorization);
        String verificationScript = reqElement.elementText("verificationScript");
        requestObject.setVerificationScript(verificationScript);
        List rawValidationSteps = reqElement.elements("validationSteps");
        if (rawValidationSteps != null) {
            List<ValidationStep> validationSteps = rawValidationSteps.stream().map(rawStepI -> ObjectRepository.parseValidationStep(rawStepI, substitutor)).collect(Collectors.toList());
            requestObject.setValidationSteps(validationSteps);
        }
        boolean followRedirects = Boolean.valueOf(reqElement.elementText("followRedirects"));
        requestObject.setFollowRedirects(followRedirects);
        return requestObject;
    }

    private static ValidationStep parseValidationStep(Element rawStep, StrSubstitutor substitutor) {
        ValidationStep step = new ValidationStep();
        List rawProps = rawStep.elements();
        rawProps.forEach(propI -> {
            String propName = propI.getName();
            String propValue = propI.getStringValue();
            String parseValue = substitutor.replace(propValue);
            ObjectUtil.parseAndSet(step, propName, parseValue);
        });
        return step;
    }

    private static String buildUrlFromRaw(String rawUrl, StrSubstitutor substitutor) {
        URLBuilder urlBuilder = new URLBuilder(rawUrl);
        List rawQueryParams = urlBuilder.getQueryParams();
        ArrayList processedQueryParams = new ArrayList();
        rawQueryParams.stream().forEach(p -> {
            String variableExpandedName = substitutor.replace(p.getName());
            String variableExpandedValue = substitutor.replace(p.getValue());
            String escapedName = HttpUtils.escapePathSegment(variableExpandedName);
            String escapedValue = HttpUtils.escapePathSegment(variableExpandedValue);
            processedQueryParams.add(new NameValuePair(escapedName, escapedValue));
        });
        urlBuilder.setParameters(processedQueryParams);
        String url = urlBuilder.buildString();
        url = substitutor.replace(url);
        return url;
    }

    public static RequestObject findRequestObject(String requestObjectId, File objectFile) {
        try {
            Element reqElement = new SAXReader().read(objectFile).getRootElement();
            List variableElements = reqElement.elements("variables");
            Map<String, Object> variables = Collections.emptyMap();
            if (variableElements != null) {
                Map<String, String> rawVariables = ObjectRepository.parseRequestObjectVariables(variableElements);
                variables = ObjectRepository.evaluateVariables(rawVariables);
            }
            return ObjectRepository.findRequestObject(requestObjectId, reqElement, RunConfiguration.getProjectDir(), variables);
        }
        catch (Exception e) {
            logger.logWarning(MessageFormat.format(StringConstants.TO_LOG_WARNING_CANNOT_GET_TEST_OBJECT_X_BECAUSE_OF_Y, requestObjectId, ExceptionsUtil.getMessageForThrowable(e)), null, e);
            return null;
        }
    }

    private static Map<String, String> parseRequestObjectVariables(List<Element> elements) {
        Map<String, String> variableMap = elements.stream().collect(Collectors.toMap(element -> element.elementText(PROPERTY_NAME), element -> element.elementText("defaultValue")));
        return variableMap;
    }

    private static Map<String, Object> evaluateVariables(Map<String, String> rawVariables) throws IOException, ClassNotFoundException, ResourceException, ScriptException {
        ScriptEngine scriptEngine = ObjectRepository.getScriptEngine();
        HashMap<String, Object> evaluatedVariables = new HashMap<String, Object>();
        for (Map.Entry<String, String> variableEntry : rawVariables.entrySet()) {
            String variableName = variableEntry.getKey();
            String variableValue = variableEntry.getValue();
            Object evaluatedValue = scriptEngine.runScriptWithoutLogging(variableValue, new Binding());
            evaluatedVariables.put(variableName, evaluatedValue);
        }
        return evaluatedVariables;
    }

    private static boolean isBodySupported(RequestObject requestObject) {
        String restRequestMethod = requestObject.getRestRequestMethod();
        return !"GET".contains(restRequestMethod);
    }

    private static List<TestObjectProperty> parseProperties(List<Element> elements) {
        return ObjectRepository.parseProperties(elements, new StrSubstitutor());
    }

    private static List<TestObjectProperty> parseProperties(List<Element> elements, StrSubstitutor substitutor) {
        ArrayList<TestObjectProperty> props = new ArrayList<TestObjectProperty>();
        for (Element propertyElement : elements) {
            TestObjectProperty objectProperty = new TestObjectProperty();
            String propertyName = propertyElement.elementText(PROPERTY_NAME);
            ConditionType propertyCondition = ConditionType.fromValue(propertyElement.elementText(PROPERTY_CONDITION));
            String propertyValue = propertyElement.elementText(PROPERTY_VALUE);
            boolean isPropertySelected = Boolean.valueOf(propertyElement.elementText(PROPERTY_IS_SELECTED));
            objectProperty.setName(substitutor.replace(propertyName));
            objectProperty.setCondition(propertyCondition);
            objectProperty.setValue(substitutor.replace(propertyValue));
            objectProperty.setActive(isPropertySelected);
            props.add(objectProperty);
        }
        return props;
    }

    private static RequestAuthorization parseAuthorization(List<Element> requestElements) {
        BasicRequestAuthorization retValue = null;
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Element authorizationElement : requestElements) {
            String authorizationType = authorizationElement.elementText("authorizationType");
            if (authorizationElement.elements("authorizationInfo").size() <= 0) continue;
            Element authorizationInfo = (Element)authorizationElement.elements("authorizationInfo").get(0);
            List elementObjects = authorizationInfo.elements(PROPERTY_ENTRY);
            for (Element element : elementObjects) {
                variables.put(element.elementText(PROPERTY_KEY), element.elementText(PROPERTY_VALUE));
            }
            if (authorizationType.equals(AUTH_TYPE_NTLM)) {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)((String)variables.get("password")));
                String password = "";
                try {
                    password = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
                }
                catch (IOException | GeneralSecurityException exception) {
                    return null;
                }
                String username = (String)variables.get("username");
                String domain = (String)variables.get("domain");
                String workstation = (String)variables.get("workstation");
                retValue = new NTLMAuthorization(username, password, domain, workstation);
                continue;
            }
            if (authorizationType.equals(AUTH_TYPE_DIGEST)) {
                try {
                    retValue = new DigestAuthorization(variables);
                }
                catch (Exception e) {
                    logger.logMessage(LogLevel.WARNING, String.format("Fails to constructing the DigestAuthorization from the text. The Authorization of the test object will be null. Text: %s", authorizationInfo.getText()), e);
                }
                continue;
            }
            if (!authorizationType.equals(AUTH_TYPE_AWS_SIGNATURE)) continue;
            try {
                retValue = AwsSignatureAuthorization.adapt(variables);
            }
            catch (Exception e) {
                logger.logMessage(LogLevel.WARNING, String.format("Fails to constructing the AwsSignatureAuthorization from the text. The Authorization of the test object will be null. Text: %s", authorizationInfo.getText()), e);
            }
        }
        return retValue;
    }

    private static boolean hasAuthorizationHeaders(RequestObject requestObject) {
        if (requestObject.getHttpHeaderProperties() == null) {
            return false;
        }
        return requestObject.getHttpHeaderProperties().stream().anyMatch(header -> AUTHORIZATION_HEADER.equalsIgnoreCase(header.getName()) || header.getName().startsWith("Authorization:"));
    }

    private static BasicRequestAuthorization findInheritedAuthorizationFromPath(String requestObjectId, String projectDir) {
        try {
            File requestFile = new File(projectDir, requestObjectId + WEBELEMENT_FILE_EXTENSION);
            File currentDir = requestFile.getParentFile();
            while (currentDir != null) {
                File metaFile = new File(currentDir, API_COLLECTION_META_EXTENSION);
                if (!metaFile.exists()) break;
                BasicRequestAuthorization auth = ObjectRepository.parseApiCollectionAuthorization(metaFile);
                if (auth != null) {
                    return auth;
                }
                currentDir = currentDir.getParentFile();
            }
            return null;
        }
        catch (Exception e) {
            logger.logWarning("Failed to find inherited authorization: " + ExceptionsUtil.getMessageForThrowable(e), null, e);
            return null;
        }
    }

    private static BasicRequestAuthorization parseApiCollectionAuthorization(File metaFile) {
        Element authorizationElement;
        block6: {
            Element rootElement;
            block5: {
                SAXReader reader = SAXReaderProvider.newInstance();
                rootElement = reader.read(metaFile).getRootElement();
                if ("ApiCollectionEntity".equals(rootElement.getName())) break block5;
                return null;
            }
            authorizationElement = rootElement.element("authorization");
            if (authorizationElement != null) break block6;
            return null;
        }
        try {
            return ObjectRepository.parseApiCollectionAuthorizationDirect(authorizationElement);
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Authorization info is not available or is corrupted in API Collection at " + metaFile.getAbsolutePath(), e);
        }
        catch (Exception e) {
            logger.logWarning("Failed to parse API Collection authorization: " + ExceptionsUtil.getMessageForThrowable(e), null, e);
            return null;
        }
    }

    private static BasicRequestAuthorization parseApiCollectionAuthorizationDirect(Element authorizationElement) {
        String authorizationType;
        block5: {
            authorizationType = authorizationElement.elementText("authorizationType");
            if (authorizationType != null) break block5;
            return null;
        }
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            Element authorizationInfo = authorizationElement.element("authorizationInfo");
            if (authorizationInfo != null) {
                List entryElements = authorizationInfo.elements(PROPERTY_ENTRY);
                for (Element entry : entryElements) {
                    String key = entry.elementText(PROPERTY_KEY);
                    String value = entry.elementText(PROPERTY_VALUE);
                    if (key == null || value == null) continue;
                    variables.put(key, value);
                }
            }
            BasicRequestAuthorization auth = new BasicRequestAuthorization();
            auth.setAuthorizationType(authorizationType);
            auth.setAuthorizationInfo(variables);
            return auth;
        }
        catch (Exception e) {
            logger.logWarning("Failed to parse API Collection authorization element: " + ExceptionsUtil.getMessageForThrowable(e), null, e);
            return null;
        }
    }

    private static void applyInheritedAuthorization(RequestObject requestObject, BasicRequestAuthorization inheritedAuth) {
        String authType = inheritedAuth.getAuthorizationType();
        if (authType == null) {
            return;
        }
        Map<String, String> authInfo = inheritedAuth.getAuthorizationInfo();
        if (authInfo == null) {
            return;
        }
        switch (authType) {
            case "Basic": {
                ObjectRepository.addBasicAuthHeader(requestObject, authInfo);
                break;
            }
            case "Bearer": {
                requestObject.setRequestAuthorization(inheritedAuth);
                ObjectRepository.addBearerAuthHeader(requestObject, authInfo);
                break;
            }
            case "OAuth 1.0": {
                requestObject.setRequestAuthorization(inheritedAuth);
                ObjectRepository.addOAuth1AuthHeaders(requestObject, authInfo);
                break;
            }
            case "OAuth 2.0": {
                requestObject.setRequestAuthorization(inheritedAuth);
                ObjectRepository.addOAuth2AuthHeaders(requestObject, authInfo);
                break;
            }
            case "AWS Signature": 
            case "NTLM": 
            case "Digest": {
                requestObject.setRequestAuthorization(inheritedAuth);
            }
        }
    }

    private static void addBasicAuthHeader(RequestObject requestObject, Map<String, String> authInfo) {
        String username = authInfo.get("username");
        String password = authInfo.get("password");
        if (username != null && password != null) {
            String encoded = Base64.basicEncode(username, password);
            ObjectRepository.addAuthorizationHeader(requestObject, "Basic " + encoded);
        }
    }

    private static void addBearerAuthHeader(RequestObject requestObject, Map<String, String> authInfo) {
        String token = authInfo.get("bearerToken");
        if (token != null) {
            ObjectRepository.addAuthorizationHeader(requestObject, "Bearer " + token);
        }
    }

    private static void addOAuth1AuthHeaders(RequestObject requestObject, Map<String, String> authInfo) {
        String realm;
        String tokenSecret;
        String token;
        String signatureMethod;
        String consumerSecret;
        String consumerKey = authInfo.get("consumer_key");
        if (consumerKey != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_consumer_key", consumerKey);
        }
        if ((consumerSecret = authInfo.get("consumer_secret")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_consumer_secret", consumerSecret);
        }
        if ((signatureMethod = authInfo.get("signature_method")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_signature_method", signatureMethod);
        }
        if ((token = authInfo.get("token")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_token", token);
        }
        if ((tokenSecret = authInfo.get("token_secret")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_token_secret", tokenSecret);
        }
        if ((realm = authInfo.get("realm")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_realm", realm);
        }
    }

    private static void addOAuth2AuthHeaders(RequestObject requestObject, Map<String, String> authInfo) {
        String refreshToken;
        String authorizationCode;
        String redirectUri;
        String accessTokenUrl;
        String authUrl;
        String password;
        String username;
        String state;
        String scope;
        String tokenType;
        String clientSecret;
        String clientId;
        String accessToken;
        String grantType = authInfo.get("grant_type");
        if (grantType != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:type", AUTH_TYPE_OAUTH_2_0);
        }
        if ((accessToken = authInfo.get("access_token")) != null) {
            ObjectRepository.addAuthorizationHeader(requestObject, "Bearer " + accessToken);
        }
        if ((clientId = authInfo.get("client_id")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_consumer_key", clientId);
        }
        if ((clientSecret = authInfo.get("client_secret")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:oauth_consumer_secret", clientSecret);
        }
        if ((tokenType = authInfo.get("token_type")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:token_type", tokenType);
        }
        if ((scope = authInfo.get("scope")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:scope", scope);
        }
        if ((state = authInfo.get("state")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:state", state);
        }
        if ((username = authInfo.get("username")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:username", username);
        }
        if ((password = authInfo.get("password")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:password", password);
        }
        if ((authUrl = authInfo.get("auth_url")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:auth_url", authUrl);
        }
        if ((accessTokenUrl = authInfo.get("access_token_url")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:access_token_url", accessTokenUrl);
        }
        if ((redirectUri = authInfo.get("redirect_uri")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:redirect_uri", redirectUri);
        }
        if ((authorizationCode = authInfo.get("code")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:authorization_code", authorizationCode);
        }
        if ((refreshToken = authInfo.get("refresh_token")) != null) {
            ObjectRepository.addHeader(requestObject, "Authorization:refresh_token", refreshToken);
        }
    }

    private static void addAuthorizationHeader(RequestObject requestObject, String headerValue) {
        ObjectRepository.addHeader(requestObject, AUTHORIZATION_HEADER, headerValue);
    }

    private static void addHeader(RequestObject requestObject, String name, String value) {
        TestObjectProperty header = new TestObjectProperty(name, ConditionType.EQUALS, value, true);
        requestObject.getHttpHeaderProperties().add(header);
    }
}

