/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import java.util.List;
import java.util.Map;

public class TestObjectBuilder {
    private TestObject testObject;

    public TestObjectBuilder(String objectId) {
        this.testObject = new TestObject(objectId);
    }

    public TestObjectBuilder(TestObject inputObject) {
        if (inputObject instanceof MobileTestObject) {
            MobileTestObject mobileInput = (MobileTestObject)inputObject;
            MobileTestObject mobileTestObject = new MobileTestObject(mobileInput.getObjectId());
            mobileTestObject.setLocator(mobileInput.getLocator());
            mobileTestObject.setLocatorStrategy(mobileInput.getLocatorStrategy());
            mobileTestObject.setLocatorCollection(mobileInput.getLocatorCollection());
            this.copyCommonFields(mobileInput, mobileTestObject);
            this.testObject = mobileTestObject;
        } else {
            TestObject newTestObject = new TestObject(inputObject.getObjectId());
            newTestObject.setSelectorMethod(inputObject.getSelectorMethod());
            newTestObject.setSmartSelectorCollection(inputObject.getSmartSelectorCollection());
            this.copyCommonFields(inputObject, newTestObject);
            this.testObject = newTestObject;
        }
    }

    private void copyCommonFields(TestObject from, TestObject to) {
        to.setParentObject(from.getParentObject());
        to.setParentObjectShadowRoot(from.isParentObjectShadowRoot());
        to.setProperties(from.getProperties());
        to.setXpaths(from.getXpaths());
        to.setImagePath(from.getImagePath());
        to.setUseRelativeImagePath(from.getUseRelativeImagePath());
    }

    public TestObjectBuilder withParentObject(TestObject parentObject) {
        this.testObject.setParentObject(parentObject);
        return this;
    }

    public TestObjectBuilder withIsParentObjectShadowRootEqual(boolean val) {
        this.testObject.setParentObjectShadowRoot(val);
        return this;
    }

    public TestObjectBuilder withProperties(List<TestObjectProperty> properties) {
        this.testObject.setProperties(properties);
        return this;
    }

    public TestObjectBuilder withXPaths(List<TestObjectXpath> xpaths) {
        this.testObject.setXpaths(xpaths);
        return this;
    }

    public TestObjectBuilder withImagePath(String path) {
        this.testObject.setImagePath(path);
        return this;
    }

    public TestObjectBuilder withUseRelativeImagePathEqual(boolean val) {
        this.testObject.setUseRelativeImagePath(val);
        return this;
    }

    public TestObjectBuilder withSelectorMethod(SelectorMethod selectorMethod) {
        this.testObject.setSelectorMethod(selectorMethod);
        return this;
    }

    public TestObjectBuilder setSelectorValue(SelectorMethod selectorMethod, String selectorValue) {
        this.testObject.setSelectorValue(selectorMethod, selectorValue);
        return this;
    }

    public TestObjectBuilder withSelectorCollection(Map<SelectorMethod, String> selectorCollection) {
        selectorCollection.forEach((selectorMethod, selectorValue) -> this.setSelectorValue((SelectorMethod)((Object)selectorMethod), (String)selectorValue));
        return this;
    }

    public TestObjectBuilder withMobileLocator(String mobileLocator) {
        if (this.testObject instanceof MobileTestObject) {
            ((MobileTestObject)this.testObject).setLocator(mobileLocator);
        }
        return this;
    }

    public TestObjectBuilder withMobileLocatorStrategy(LocatorStrategy strategy) {
        if (this.testObject instanceof MobileTestObject) {
            ((MobileTestObject)this.testObject).setLocatorStrategy(strategy);
        }
        return this;
    }

    public TestObject build() {
        return this.testObject;
    }
}

