/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.DigestAlgorithmDirective;
import com.kms.katalon.core.testobject.authorization.DigestQualityOfProtectionDirective;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DigestAuthorization
extends BasicRequestAuthorization {
    private static final long serialVersionUID = 1L;
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String REALM_KEY = "realm";
    private static final String NONCE_KEY = "nonce";
    private static final String ALGORITHM_KEY = "algorithm";
    private static final String QOP_KEY = "qop";
    private static final String NONCE_COUNT_KEY = "nonce-count";
    private static final String CLIENT_NONCE_KEY = "client-nonce";
    private static final String OPAQUE_KEY = "opaque";
    private static final String OVERRIDE_CHALLENGE_KEY = "override-challenge";
    public static final String AUTHORIZATION_TYPE = "Digest";

    public DigestAuthorization(String username, String password) throws UnsupportedEncodingException, GeneralSecurityException {
        HashMap<String, String> authorizationInfo = new HashMap<String, String>();
        authorizationInfo.put(USERNAME_KEY, username);
        authorizationInfo.put(PASSWORD_KEY, this.encrypt(password));
        this.init(authorizationInfo);
    }

    public DigestAuthorization(String username, String password, String realm, String nonce, DigestAlgorithmDirective algorithm, DigestQualityOfProtectionDirective qop, String nonceCount, String clientNounce, String opaque) throws UnsupportedEncodingException, GeneralSecurityException {
        HashMap<String, String> authorizationInfo = new HashMap<String, String>();
        authorizationInfo.put(USERNAME_KEY, username);
        authorizationInfo.put(PASSWORD_KEY, this.encrypt(password));
        authorizationInfo.put(OVERRIDE_CHALLENGE_KEY, Boolean.toString(true));
        if (Objects.nonNull(realm)) {
            authorizationInfo.put(REALM_KEY, realm);
        }
        if (Objects.nonNull(nonce)) {
            authorizationInfo.put(NONCE_KEY, nonce);
        }
        if (Objects.nonNull((Object)algorithm)) {
            authorizationInfo.put(ALGORITHM_KEY, algorithm.getName());
        }
        if (Objects.nonNull((Object)qop) && qop != DigestQualityOfProtectionDirective.UNSPECIFIED) {
            authorizationInfo.put(QOP_KEY, qop.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)nonceCount)) {
            try {
                Integer.parseInt(nonceCount);
                authorizationInfo.put(NONCE_COUNT_KEY, nonceCount);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("The nonceCount text value %s isn't in number format", nonceCount), e);
            }
        }
        if (Objects.nonNull(clientNounce)) {
            authorizationInfo.put(CLIENT_NONCE_KEY, clientNounce);
        }
        if (Objects.nonNull(opaque)) {
            authorizationInfo.put(OPAQUE_KEY, opaque);
        }
        this.init(authorizationInfo);
    }

    public DigestAuthorization(RequestAuthorization source) throws UnsupportedEncodingException, GeneralSecurityException {
        this(source.getAuthorizationInfo());
    }

    public DigestAuthorization(Map<String, String> props) throws UnsupportedEncodingException, GeneralSecurityException {
        this.init(props);
    }

    public String getUsername() {
        return this.getWithEmpty(USERNAME_KEY);
    }

    public String getPassword() throws GeneralSecurityException, IOException {
        String encryptedValue = this.getWithEmpty(PASSWORD_KEY);
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedValue);
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return "";
    }

    public String getRealm() {
        return this.getWithEmpty(REALM_KEY);
    }

    public String getNonce() {
        return this.getWithEmpty(NONCE_KEY);
    }

    public DigestAlgorithmDirective getAlgorithm() {
        String vl = this.getAuthorizationInfo().get(ALGORITHM_KEY);
        if (StringUtils.isBlank((CharSequence)vl)) {
            return DigestAlgorithmDirective.MD5;
        }
        return DigestAlgorithmDirective.fromString(vl);
    }

    public DigestQualityOfProtectionDirective getQop() {
        String vl = this.getAuthorizationInfo().get(QOP_KEY);
        if (StringUtils.isBlank((CharSequence)vl)) {
            return DigestQualityOfProtectionDirective.UNSPECIFIED;
        }
        return DigestQualityOfProtectionDirective.fromString(vl);
    }

    public Integer getNonceCount() {
        String vl = this.getWithEmpty(NONCE_COUNT_KEY);
        if (StringUtils.isNotBlank((CharSequence)vl)) {
            return Integer.parseInt(vl);
        }
        return null;
    }

    public String getClientNounce() {
        return this.getWithEmpty(CLIENT_NONCE_KEY);
    }

    public String getOpaque() {
        return this.getWithEmpty(OPAQUE_KEY);
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getUsername())) {
            throw new IllegalArgumentException("The directive 'username' is required but unavailable");
        }
        if (Objects.isNull(this.getAuthorizationInfo().get(PASSWORD_KEY))) {
            throw new IllegalArgumentException("The directive 'password' is required but unavailable");
        }
        if (!this.useChallengeResponseMechanism()) {
            if (StringUtils.isBlank((CharSequence)this.getRealm())) {
                throw new IllegalArgumentException("The directive 'realm' is required but unavailable");
            }
            if (StringUtils.isBlank((CharSequence)this.getNonce())) {
                throw new IllegalArgumentException("The directive 'nonce' is required but unavailable");
            }
        }
    }

    public boolean useChallengeResponseMechanism() {
        String vl;
        Map<String, String> dict = this.getAuthorizationInfo();
        if (dict.containsKey(OVERRIDE_CHALLENGE_KEY) && StringUtils.isNotBlank((CharSequence)(vl = dict.get(OVERRIDE_CHALLENGE_KEY)))) {
            return Boolean.valueOf(vl) == false;
        }
        return true;
    }

    public static boolean is(RequestAuthorization ra) {
        String at;
        if (Objects.nonNull(ra) && StringUtils.isNotBlank((CharSequence)(at = ra.getAuthorizationType()))) {
            return at.equals(AUTHORIZATION_TYPE);
        }
        return false;
    }

    private String encrypt(String vl) throws UnsupportedEncodingException, GeneralSecurityException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)vl);
        return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
    }

    private void init(Map<String, String> info) {
        this.setAuthorizationType(AUTHORIZATION_TYPE);
        this.setAuthorizationInfo(info);
    }

    private String getWithEmpty(String key) {
        Map<String, String> dict = this.getAuthorizationInfo();
        if (!dict.containsKey(key)) {
            return "";
        }
        String vl = dict.get(key);
        return StringUtils.isBlank((CharSequence)vl) ? "" : vl;
    }
}

