/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

import com.kms.katalon.core.constants.OAuth2Constants;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.OAuth2GrantType;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OAuth2Authorization
extends BasicRequestAuthorization {
    private static final long serialVersionUID = 1L;
    private static final String GRANT_TYPE_KEY = OAuth2Constants.GRANT_TYPE;
    private static final String USERNAME_KEY = OAuth2Constants.USERNAME;
    private static final String PASSWORD_KEY = OAuth2Constants.PW;
    private static final String CALLBACK_URL_KEY = OAuth2Constants.REDIRECT_URI;
    private static final String AUTH_URL_KEY = OAuth2Constants.AUTH_URL;
    private static final String ACCESS_TOKEN_URL_KEY = OAuth2Constants.ACCESS_TOKEN_URL;
    private static final String STATE_KEY = OAuth2Constants.STATE;
    private static final String CONSUMER_ID_KEY = OAuth2Constants.CLIENT_ID;
    private static final String CONSUMER_SECRET_KEY = OAuth2Constants.CLIENT_SECRET;
    private static final String AUTHORIZATION_CODE_KEY = OAuth2Constants.AUTHORIZATION_CODE;
    private static final String SCOPE_KEY = "scope";
    private static final String ACCESS_TOKEN_KEY = OAuth2Constants.ACCESS_TOKEN;
    private static final String REFRESH_TOKEN_KEY = OAuth2Constants.REFRESH_TOKEN;
    private static final String TOKEN_TYPE_KEY = OAuth2Constants.TOKEN_TYPE;
    public static final String AUTHORIZATION_TYPE = "OAuth2";
    public static final String AUTHORIZATION_TYPE_OAUTH_2_0 = OAuth2Constants.AUTHORIZATION_TYPE_OAUTH_2_0;

    public OAuth2Authorization(RequestAuthorization source) throws UnsupportedEncodingException, GeneralSecurityException {
        this(source.getAuthorizationInfo());
    }

    public OAuth2Authorization(Map<String, String> props) {
        this.init(props);
    }

    public OAuth2Authorization(OAuth2GrantType grantType, String username, String password, String callbackUrl, String authUrl, String accessTokenUrl, String state, String clientId, String clientSecret, String authorizationCode, String scope, String accessToken, String refreshToken, String tokenType) throws UnsupportedEncodingException, GeneralSecurityException {
        HashMap<String, String> authorizationInfo = new HashMap<String, String>();
        authorizationInfo.put(GRANT_TYPE_KEY, grantType.name());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            authorizationInfo.put(USERNAME_KEY, username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            authorizationInfo.put(PASSWORD_KEY, OAuth2Authorization.encrypt(password));
        }
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            authorizationInfo.put(CALLBACK_URL_KEY, callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)authUrl)) {
            authorizationInfo.put(AUTH_URL_KEY, authUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)accessTokenUrl)) {
            authorizationInfo.put(ACCESS_TOKEN_URL_KEY, accessTokenUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            authorizationInfo.put(STATE_KEY, state);
        }
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            authorizationInfo.put(CONSUMER_ID_KEY, clientId);
        }
        if (StringUtils.isNotBlank((CharSequence)clientSecret)) {
            authorizationInfo.put(CONSUMER_SECRET_KEY, OAuth2Authorization.encrypt(clientSecret));
        }
        if (StringUtils.isNotBlank((CharSequence)authorizationCode)) {
            authorizationInfo.put(AUTHORIZATION_CODE_KEY, authorizationCode);
        }
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            authorizationInfo.put(SCOPE_KEY, scope);
        }
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            authorizationInfo.put(ACCESS_TOKEN_KEY, accessToken);
        }
        if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
            authorizationInfo.put(REFRESH_TOKEN_KEY, refreshToken);
        }
        if (StringUtils.isNotBlank((CharSequence)tokenType)) {
            authorizationInfo.put(TOKEN_TYPE_KEY, tokenType);
        }
        this.init(authorizationInfo);
    }

    public static OAuth2Authorization adapt(Map<String, String> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("The Map<String, String> parameter is required but null");
        }
        return new OAuth2Authorization(properties);
    }

    public static OAuth2Authorization adapt(RequestAuthorization requestAuthorization) throws UnsupportedEncodingException, GeneralSecurityException {
        if (Objects.isNull(requestAuthorization)) {
            throw new IllegalArgumentException("The RequestAuthorization parameter is required but null");
        }
        return new OAuth2Authorization(requestAuthorization);
    }

    public String getUsername() {
        return this.getWithEmpty(USERNAME_KEY);
    }

    public String getAuthorizationCode() {
        return this.getWithEmpty(AUTHORIZATION_CODE_KEY);
    }

    public String getPassword() throws GeneralSecurityException, IOException {
        String encryptedValue = this.getWithEmpty(PASSWORD_KEY);
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedValue);
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return "";
    }

    public String getGrantType() {
        return this.getWithEmpty(GRANT_TYPE_KEY);
    }

    public String getClientId() {
        return this.getWithEmpty(CONSUMER_ID_KEY);
    }

    public String getClientSecret() throws GeneralSecurityException, IOException {
        String encryptedValue = this.getWithEmpty(CONSUMER_SECRET_KEY);
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedValue);
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return "";
    }

    public String getAccessTokenUrl() {
        return this.getWithEmpty(ACCESS_TOKEN_URL_KEY);
    }

    public String getAuthUrl() {
        return this.getWithEmpty(AUTH_URL_KEY);
    }

    public String getRedirectUri() {
        return this.getWithEmpty(CALLBACK_URL_KEY);
    }

    public String getScope() {
        return this.getWithEmpty(SCOPE_KEY);
    }

    public String getState() {
        return this.getWithEmpty(STATE_KEY);
    }

    public String getAccessToken() {
        return this.getWithEmpty(ACCESS_TOKEN_KEY);
    }

    public String getRefreshToken() {
        return this.getWithEmpty(REFRESH_TOKEN_KEY);
    }

    public String getTokenType() {
        return this.getWithEmpty(TOKEN_TYPE_KEY);
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getGrantType())) {
            throw new IllegalArgumentException("The parameter 'grant_type' is required but unavailable");
        }
    }

    public static boolean is(RequestAuthorization requestAuthorization) {
        String authType;
        if (Objects.nonNull(requestAuthorization) && StringUtils.isNotBlank((CharSequence)(authType = requestAuthorization.getAuthorizationType()))) {
            return authType.equalsIgnoreCase(AUTHORIZATION_TYPE) || authType.equalsIgnoreCase(AUTHORIZATION_TYPE_OAUTH_2_0);
        }
        return false;
    }

    public static String encrypt(String vl) throws UnsupportedEncodingException, GeneralSecurityException {
        if (StringUtils.isBlank((CharSequence)vl)) {
            return "";
        }
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)vl);
        return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
    }

    private void init(Map<String, String> info) {
        this.setAuthorizationType(AUTHORIZATION_TYPE_OAUTH_2_0);
        this.setAuthorizationInfo(info);
    }

    private String getWithEmpty(String key) {
        Map<String, String> dict = this.getAuthorizationInfo();
        if (!dict.containsKey(key)) {
            return "";
        }
        String value = dict.get(key);
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }
}

