/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.impl;

import com.kms.katalon.core.testobject.HttpBodyContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class HttpBinaryBodyContent
implements HttpBodyContent {
    private static final String DF_CONTENT_TYPE = "application/octet-stream";
    private final byte[] binaryData;
    private final String contentType;
    private final String contentEncoding;

    public HttpBinaryBodyContent(byte[] binaryData) {
        this(binaryData, DF_CONTENT_TYPE);
    }

    public HttpBinaryBodyContent(byte[] binaryData, String contentType) {
        this(binaryData, contentType, null);
    }

    public HttpBinaryBodyContent(byte[] binaryData, String contentType, String contentEncoding) {
        this.binaryData = binaryData != null ? binaryData : new byte[]{};
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    @Override
    public String getContentType() {
        if (StringUtils.isEmpty((String)this.contentType)) {
            return DF_CONTENT_TYPE;
        }
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        return this.binaryData.length;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public InputStream getInputStream() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(this.binaryData);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.binaryData);
        outstream.flush();
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }
}

