/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.trymonad;

import com.kms.katalon.core.trymonad.Failure;
import com.kms.katalon.core.trymonad.Success;
import com.kms.katalon.core.trymonad.TryConsumer;
import com.kms.katalon.core.trymonad.TryMapFunction;
import com.kms.katalon.core.trymonad.TrySupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Try<T> {
    protected Try() {
    }

    public static <U> Try<U> ofFailable(TrySupplier<U> f) {
        Objects.requireNonNull(f);
        try {
            return Try.successful(f.get());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    public abstract <U> Try<U> map(TryMapFunction<? super T, ? extends U> var1);

    public abstract <U> Try<U> flatMap(TryMapFunction<? super T, Try<U>> var1);

    public abstract T recover(Function<? super Throwable, T> var1);

    public abstract Try<T> recoverWith(TryMapFunction<? super Throwable, Try<T>> var1);

    public abstract T orElse(T var1);

    public abstract Try<T> orElseTry(TrySupplier<T> var1);

    public abstract <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    public abstract T get() throws Throwable;

    public abstract T getUnchecked();

    public abstract boolean isSuccess();

    public abstract <E extends Throwable> Try<T> onSuccess(TryConsumer<T, E> var1) throws E;

    public abstract <E extends Throwable> Try<T> onFailure(TryConsumer<Throwable, E> var1) throws E;

    public abstract Try<T> filter(Predicate<T> var1);

    public abstract Optional<T> toOptional();

    public static <U> Try<U> failure(Throwable e) {
        return new Failure(e);
    }

    public static <U> Try<U> successful(U x) {
        return new Success<U>(x);
    }
}

