/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.impl.ChromeServiceImpl;
import com.github.kklisura.cdt.services.types.ChromeTab;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;

public class CDTUtils {
    private static final KeywordLogger logger = KeywordLogger.getInstance(CDTUtils.class);

    private CDTUtils() {
    }

    public static ChromeDevToolsService getService(WebDriver driver) {
        String[] debugAddress;
        block5: {
            debugAddress = CDTUtils.getServiceEndpoint(driver);
            if (debugAddress != null && debugAddress.length >= 2) break block5;
            return null;
        }
        try {
            String host = debugAddress[0];
            int port = Integer.parseInt(debugAddress[1]);
            ChromeServiceImpl chromeService = new ChromeServiceImpl(host, port);
            List tabs = chromeService.getTabs();
            String currentUrl = driver.getCurrentUrl();
            if (currentUrl.equals("chrome://new-tab-page/")) {
                currentUrl = "chrome://newtab/";
            }
            for (ChromeTab tabI : tabs) {
                if (!tabI.getUrl().equals(currentUrl)) continue;
                return chromeService.createDevToolsService(tabI);
            }
        }
        catch (Exception ex) {
            logger.logDebug(ExceptionsUtil.getStackTraceForThrowable(ex));
        }
        return null;
    }

    public static String[] getServiceEndpoint(WebDriver driver) {
        HasCapabilities hashCapabilities = (HasCapabilities)driver;
        Map capabilities = hashCapabilities.getCapabilities().asMap();
        if (capabilities.containsKey("goog:chromeOptions")) {
            capabilities = (Map)capabilities.get("goog:chromeOptions");
        } else if (capabilities.containsKey("ms:edgeOptions")) {
            capabilities = (Map)capabilities.get("ms:edgeOptions");
        } else {
            return new String[0];
        }
        String debugAddress = (String)capabilities.get("debuggerAddress");
        return StringUtils.isNotBlank((String)debugAddress) ? debugAddress.split(":") : new String[]{};
    }
}

