/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.classpath;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class DSLDContainerInitializer
extends ClasspathContainerInitializer {
    public static final String PLUGIN_DSLD_SUPPORT = "plugin_dsld_support";
    public static final String GLOBAL_DSLD_SUPPORT = "global_dsld_support";
    private static final File GLOBAL_DSLD_LOCATION = DSLDContainerInitializer.resolveGlobalDsldLocation();

    private static File resolveGlobalDsldLocation() {
        String dotGroovyLocation;
        if (GroovyDSLCoreActivator.getDefault().isDSLDDisabled() || (dotGroovyLocation = CompilerUtils.getDotGroovyLocation()) == null) {
            return null;
        }
        File globalDsldDir = new File(dotGroovyLocation + "/greclipse/global_dsld_support");
        if (!globalDsldDir.exists()) {
            try {
                globalDsldDir.mkdirs();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (globalDsldDir.exists()) {
            return globalDsldDir;
        }
        GroovyDSLCoreActivator.logWarning("Cannot create DSL support location at " + globalDsldDir.getPath() + ". Location is read-only or a security manager is preventing it.");
        return null;
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new DSLDClasspathContainer()}, null);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject javaProject) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
        if (container instanceof DSLDClasspathContainer) {
            ((DSLDClasspathContainer)container).reset();
        }
    }

    private static class DSLDClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] entries;

        private DSLDClasspathContainer() {
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.entries == null) {
                this.entries = DSLDClasspathContainer.resolveEntries();
            }
            return this.entries;
        }

        public String getDescription() {
            return "Groovy DSL Support";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return GroovyDSLCoreActivator.CLASSPATH_CONTAINER_ID;
        }

        void reset() {
            this.entries = null;
        }

        protected static IClasspathEntry[] resolveEntries() {
            if (GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
                return new IClasspathEntry[0];
            }
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            if (GLOBAL_DSLD_LOCATION != null && GLOBAL_DSLD_LOCATION.exists()) {
                Path path = new Path(GLOBAL_DSLD_LOCATION.getAbsolutePath());
                newEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
            }
            try {
                Bundle groovyBundle = CompilerUtils.getActiveGroovyBundle();
                URL dsldSupportPath = groovyBundle.getEntry(DSLDContainerInitializer.PLUGIN_DSLD_SUPPORT);
                Assert.isTrue((dsldSupportPath != null ? 1 : 0) != 0, (String)"Plugin DSLD location not found");
                Path path = new Path(FileLocator.toFileURL((URL)dsldSupportPath).getPath());
                Assert.isTrue((boolean)path.toFile().exists(), (String)("Plugin DSLD location does not exist: " + String.valueOf(path)));
                newEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
            }
            catch (Exception e) {
                GroovyDSLCoreActivator.logException(e);
            }
            return newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        }
    }
}

