/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.UUID;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.DSLContributionGroup;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;

public class ParameterContribution {
    final String name;
    final String type;
    private Parameter value;

    public ParameterContribution(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ParameterContribution(Parameter value) {
        this(value.getName(), DSLContributionGroup.getTypeName(value.getType()));
        this.value = value;
    }

    public Parameter toParameter(ResolverCache resolver) {
        if (this.value == null) {
            String typeName = this.type;
            if (this.type.indexOf(64) != -1) {
                try {
                    CompilerConfiguration conf = new CompilerConfiguration(resolver.module.getContext().getConfiguration());
                    conf.setPreviewFeatures(false);
                    conf.setScriptBaseClass(null);
                    conf.setTargetBytecode(CompilerConfiguration.DEFAULT.getTargetBytecode());
                    CompilationUnit unit = new CompilationUnit(conf, null, resolver.module.getContext().getClassLoader());
                    unit.addSource("Script" + UUID.randomUUID().toString().replace('-', '$'), "import groovy.transform.stc.*\nvoid meth(" + this.type + " " + this.name + ") {}");
                    unit.compile(5);
                    MethodNode meth = (MethodNode)unit.getFirstClassNode().getMethods("meth").get(0);
                    return meth.getParameters()[0];
                }
                catch (Exception | LinkageError e) {
                    GroovyDSLCoreActivator.logException(e);
                    String i = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
                    typeName = this.type.replaceAll("@(?:" + i + "\\.)*" + i + "(?:\\([^\\)]*\\))?\\s*", "");
                }
            }
            this.value = new Parameter(resolver != null ? resolver.resolve(typeName) : ClassHelper.dynamicType(), this.name);
        }
        return this.value;
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

