/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IValueCheckingRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.JavaValidParameterizedTypeRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.JavaTextControl;
import org.codehaus.groovy.eclipse.ui.browse.TypeBrowseSupport;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JavaTypeBrowsingControl
extends JavaTextControl {
    private static final String BROWSE = "Browse...";
    private Button browse;
    private IJavaProject project;

    public JavaTypeBrowsingControl(IDialogueControlDescriptor labelDescriptor, Point offsetLabelLocation, String initialValue, IJavaProject project) {
        super(labelDescriptor, offsetLabelLocation, initialValue);
        this.project = project;
    }

    @Override
    protected Control getManagedControl(Composite parent) {
        Composite fieldComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fieldComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fieldComposite);
        Text text = (Text)super.getManagedControl(fieldComposite);
        this.browse = new Button(fieldComposite, 8);
        this.browse.setEnabled(true);
        this.browse.setText(BROWSE);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.browse);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.heightHint = this.getButtonHeight();
        this.browse.setLayoutData((Object)data);
        this.addTypeBrowseSupport(text, this.browse, parent.getShell());
        return text;
    }

    protected void addTypeBrowseSupport(Text text, Button browse, Shell shell) {
        Text finText = text;
        new TypeBrowseSupport(shell, this.project, qualifiedName -> {
            finText.setText(qualifiedName);
            this.notifyControlChange(qualifiedName, (Control)finText);
        }).applySupport(browse, text);
    }

    protected int getButtonHeight() {
        return 23;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.browse.setEnabled(enable);
    }

    @Override
    protected IValueCheckingRule getCachedValidationRule() {
        return new JavaValidParameterizedTypeRule(this.project);
    }
}

