/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;

public class BindingSet {
    private final Map<String, Collection<Object>> namedBindings = new HashMap<String, Collection<Object>>();

    public BindingSet addToBinding(String name, Collection<?> values) {
        Collection<Object> binding = this.namedBindings.get(name);
        if (binding == null) {
            binding = new ArrayList<Object>();
            this.namedBindings.put(name, binding);
        }
        binding.addAll(values);
        return this;
    }

    public Map<String, Collection<Object>> getBindings() {
        return Collections.unmodifiableMap(this.namedBindings);
    }

    public Collection<Object> getBinding(String name) {
        Collection<Object> values = this.namedBindings.get(name);
        return values == null ? null : Collections.unmodifiableCollection(values);
    }

    public int size() {
        return this.namedBindings.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BindingSet [\n");
        for (Map.Entry<String, Collection<Object>> entry : this.namedBindings.entrySet()) {
            sb.append("  ").append(entry.getKey()).append(" : ");
            sb.append(BindingSet.printCollection(entry.getValue()));
        }
        sb.append(']');
        return sb.toString();
    }

    public static String printCollection(Collection<? extends Object> value) {
        StringBuilder sb = new StringBuilder();
        for (Object object : value) {
            sb.append(" [ ");
            sb.append(BindingSet.printValue(object));
            sb.append(" ] ");
        }
        return sb.toString();
    }

    public static String printValue(Object value) {
        if (value instanceof ClassNode) {
            return ((ClassNode)value).getName();
        }
        if (value instanceof FieldNode) {
            return ((FieldNode)value).getDeclaringClass().getName() + "." + ((FieldNode)value).getName();
        }
        if (value instanceof MethodNode) {
            return ((MethodNode)value).getDeclaringClass().getName() + "." + ((MethodNode)value).getName();
        }
        if (value instanceof PropertyNode) {
            return ((PropertyNode)value).getDeclaringClass().getName() + "." + ((PropertyNode)value).getName();
        }
        if (value instanceof MethodCallExpression) {
            return ((MethodCallExpression)value).getMethodAsString();
        }
        if (value instanceof ASTNode) {
            return ((ASTNode)value).getText();
        }
        if (value != null) {
            value.toString();
        }
        return null;
    }
}

