/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;

public class AssignedVariablePointcut
extends AbstractPointcut {
    public AssignedVariablePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext context, Object toMatch) {
        BinaryExpression enclosing = context.getCurrentScope().getEnclosingAssignment();
        if (enclosing != null && enclosing.getLeftExpression() instanceof Variable && enclosing.getLeftExpression() != context.getCurrentScope().getCurrentNode()) {
            Variable variable = (Variable)enclosing.getLeftExpression();
            Object argument = this.getFirstArgument();
            if (argument == null) {
                return Collections.singleton(enclosing);
            }
            if (argument instanceof String) {
                if (argument.equals(variable.getName())) {
                    return Collections.singleton(enclosing);
                }
            } else if (argument instanceof Pattern) {
                if (((Pattern)argument).matcher(variable.getName()).matches()) {
                    return Collections.singleton(enclosing);
                }
            } else {
                return this.matchOnPointcutArgument((IPointcut)argument, context, Collections.singleton(enclosing));
            }
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String failure = this.hasOneOrNoArgs();
        if (failure == null) {
            Object[] objectArray = this.getArgumentValues();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object argument = objectArray[n2];
                if (!(argument instanceof String || argument instanceof Pattern || argument instanceof IPointcut)) {
                    failure = "This pointcut supports exactly one argument of type String, Pattern or Pointcut.";
                }
                ++n2;
            }
        }
        if (failure != null) {
            throw new PointcutVerificationException(failure, this);
        }
        super.verify();
    }
}

