/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

public class HasArgumentsPointcut
extends FilteringPointcut<AnnotatedNode> {
    public HasArgumentsPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, AnnotatedNode.class);
    }

    @Override
    protected Collection<AnnotatedNode> explodeObject(Object toMatch) {
        Parameter[] parameters;
        if (toMatch instanceof MethodCall) {
            Expression arguments = ((MethodCall)toMatch).getArguments();
            if (arguments instanceof TupleExpression) {
                List innerArgs = ((TupleExpression)arguments).getExpressions();
                ArrayList<AnnotatedNode> actualArgs = new ArrayList<AnnotatedNode>(innerArgs.size());
                for (Expression innerArg : innerArgs) {
                    if (innerArg instanceof MapExpression) {
                        actualArgs.addAll(((MapExpression)innerArg).getMapEntryExpressions());
                        continue;
                    }
                    actualArgs.add((AnnotatedNode)innerArg);
                }
                return actualArgs;
            }
            if (arguments instanceof ListExpression) {
                return new ArrayList<AnnotatedNode>(((ListExpression)arguments).getExpressions());
            }
            if (arguments instanceof MapExpression) {
                return new ArrayList<AnnotatedNode>(((MapExpression)arguments).getMapEntryExpressions());
            }
            return Collections.singleton(arguments);
        }
        if (toMatch instanceof MethodNode && (parameters = ((MethodNode)toMatch).getParameters()) != null) {
            return new ArrayList<Parameter>(Arrays.asList(parameters));
        }
        return null;
    }

    @Override
    protected AnnotatedNode filterObject(AnnotatedNode result, GroovyDSLDContext context, String firstArgAsString) {
        boolean matches = false;
        if (firstArgAsString == null) {
            matches = true;
        } else if (result instanceof Variable) {
            matches = firstArgAsString.equals(((Variable)result).getName());
        } else if (result instanceof MapEntryExpression && ((MapEntryExpression)result).getKeyExpression() instanceof ConstantExpression) {
            matches = firstArgAsString.equals(((MapEntryExpression)result).getKeyExpression().getText());
        }
        if (matches) {
            if (result instanceof MapEntryExpression) {
                return ((MapEntryExpression)result).getValueExpression();
            }
            return result;
        }
        return null;
    }
}

