/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

public class NamePointcut
extends FilteringPointcut<Object> {
    public NamePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, Object.class);
    }

    @Override
    protected Collection<Object> explodeObject(Object toMatch) {
        Collection objects = super.explodeObject(toMatch);
        if (objects == null) {
            return null;
        }
        return objects.stream().map(object -> {
            if (object instanceof ClassNode) {
                return ((ClassNode)object).getName();
            }
            if (object instanceof FieldNode) {
                return ((FieldNode)object).getName();
            }
            if (object instanceof MethodNode) {
                return ((MethodNode)object).getName();
            }
            if (object instanceof PropertyNode) {
                return ((PropertyNode)object).getName();
            }
            if (object instanceof AnnotationNode) {
                return ((AnnotationNode)object).getClassNode().getName();
            }
            if (object instanceof MethodCallExpression) {
                return ((MethodCallExpression)object).getMethodAsString();
            }
            if (object instanceof MapEntryExpression) {
                return ((MapEntryExpression)object).getKeyExpression().getText();
            }
            if (object instanceof Variable) {
                return ((Variable)object).getName();
            }
            if (object instanceof BinaryExpression && ((BinaryExpression)object).getLeftExpression() instanceof Variable && ((BinaryExpression)object).getOperation().isA(1100)) {
                return ((Variable)((BinaryExpression)object).getLeftExpression()).getName();
            }
            if (object instanceof Expression) {
                return ((Expression)object).getText();
            }
            return object.toString();
        }).collect(Collectors.toList());
    }

    @Override
    protected Object filterObject(Object name, GroovyDSLDContext context, String firstArgAsString) {
        return firstArgAsString == null || firstArgAsString.equals(name) ? name : null;
    }
}

